package com.elitesland.order.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.order.Application;
import com.elitesland.order.param.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 发货单对外提供服务接口
 *
 * @author fred
 * @date 2021-05-31
 */
@FeignClient(name = Application.NAME, path = Application.PATH + SalDoRpcService.URI)
public interface SalDoRpcService {

    String URI = "/salDo";

    /**
     * 通过快递单号、收货人、收货人手机、平台单据号（销售订单号）、单据创建日期查询，支持分页，根据平台单号+物流单号去重
     *
     * @param salDoLogisQueryDTO 查询参数
     * @return 数据信息
     */
    @PostMapping("/querySalDoDLogis")
    ApiResult<PagingVO<SalDoLogisRespDTO>> querySalDoDLogis(@RequestBody SalDoLogisQueryDTO salDoLogisQueryDTO);

    /**
     * 集团内订单的签收参数-多次签收
     *
     * @param salDoMultiSignReqDto
     * @return
     */
    @PostMapping("/multiSign")
    ApiResult<Boolean> multiSign(@RequestBody @NotNull(message = "参数值不能为空") SalDoMultiSignReqDto salDoMultiSignReqDto);

    /**
     * 采购中心-分子公司采购收货时，生成总部销售发货单
     * 提供 销售发货单生成接口，
     * 1、参数为总部SO的条目、收货数量，并关联分子公司GR的条目。
     * 2、生成的DO，ROOT为总部SO的ROOT，RELATE1为总部SO，RELATE2为分子公司GR。
     * 3、生成后要签收，调用手工签收的逻辑，但是因为供应链调用DO生成时，已经扣过库存，因此不需要调用扣库存逻辑。
     *
     * @param salDoPurShipReqDTOS 参数
     * @return 发货单生成结果-失败的订单号
     */
    @PostMapping("/shipByPur")
    ApiResult<List<String>> shipByPur(@RequestBody @NotEmpty(message = "参数值不能为空") List<SalDoPurShipReqDTO> salDoPurShipReqDTOS);

    @GetMapping("/findDetailById/{id}")
    ApiResult<List<SalDoDetailRespDTO>> findDetailById(@PathVariable Long id);

    /**
     * 批量创建销售发货单
     *
     * @param salDoRpcSaveDTOS
     * @return
     */
    @PostMapping("/batch/createSalDo")
    ApiResult<List<Long>> batchCreateSalDo(@RequestBody List<SalDoSaveRpcDTO> salDoRpcSaveDTOS);


    /**
     * 快递100签收接口
     *
     * @param autoSignParamDTO
     * @return
     */
    @PostMapping("/express/sign")
    ApiResult<Boolean> expressSign(@RequestBody @NotNull(message = "参数值不能为空") SalDoAutoSignParamDTO autoSignParamDTO);
}
