package com.elitesland.order.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 销售发货和退货入库明细(SalDoD)查询结果对象
 *
 * @author fred
 * @since 2021-05-14 14:20:53
 */

@Data
@ApiModel(value = "SalDoDRespDTO", description = "销售发货和退货入库明细")
public class SalDoDVerDTO implements Serializable {
    private static final long serialVersionUID = 2674376280700689076L;
    /**
    * 记录唯一ID
    */    
    @ApiModelProperty("发货单明细id")
    private Long id;
    /**
     * 记录唯一ID
     */
    @ApiModelProperty("核销金额")
    private BigDecimal verAmt;
    /**
    * 主表ID
    */
    @ApiModelProperty("主表ID")
    private Long masId;
    /**
    * 行号
    */    
    @ApiModelProperty("行号")
    private BigDecimal lineNo;
    /**
    * 商品ID
    */    
    @ApiModelProperty("商品ID")
    private Long itemId;
    /**
    * 商品规格
    */    
    @ApiModelProperty("商品规格")
    private String itemSpec;
    /**
    * 实发数量-默认值0，库存模块回写
    */    
    @ApiModelProperty("实发数量")
    private BigDecimal qty;

    @ApiModelProperty("数量2")
    private  BigDecimal qty2;
    /**
     * 订单要求发货数
     */
    @ApiModelProperty("订单要求发货数")
    private BigDecimal soQty;
    /**
    * 单位
    */    
    @ApiModelProperty("单位")
    private String uom;
    /**
     * 含税金额
     */
    @ApiModelProperty("含税金额")
    private BigDecimal amt;
    /**
     * 关联单据ID So_ID，退货为退货订单
     */
    @ApiModelProperty("关联单据ID So_ID，退货为退货订单")
    private Long relateDocId;
    /**
     * 销售单号，退货为退货订单
     */
    @ApiModelProperty("销售单号，退货为退货订单")
    private String relateDocNo;
    /**
     * 关联单据明细ID，退货为退货订单
     */
    @ApiModelProperty("关联单据明细ID，退货为退货订单")
    private Long relateDocDid;
    /**
     * 关联单据行号，退货为退货订单
     */
    @ApiModelProperty("关联单据行号，退货为退货订单")
    private BigDecimal relateDocLineno;
    /**
     * 关联单据ID So_ID，退货为原始订单
     */
    @ApiModelProperty("关联单据ID So_ID，退货为原始订单")
    private Long relateDoc2Id;
    /**
     * 销售单号，退货为原始订单
     */
    @ApiModelProperty("销售单号，退货为原始订单")
    private String relateDoc2No;
    /**
     * 关联单据明细ID，退货为原始订单
     */
    @ApiModelProperty("关联单据明细ID，退货为原始订单")
    private Long relateDoc2Did;
    /**
     * 关联单据行号，退货为原始订单
     */
    @ApiModelProperty("关联单据行号，退货为原始订单")
    private BigDecimal relateDoc2Lineno;

    /**
     * 已签收数量-默认值 0
     */
    @ApiModelProperty("已签收数量")
    private BigDecimal confirmQty;
    /**
     * 记录根据销售单位的签收数量
     */
    @ApiModelProperty("记录根据销售单位的签收数量")
    private BigDecimal confirmQty2;
    /**
     * 已签收金额
     */
    @ApiModelProperty("已签收金额")
    private BigDecimal confirmAmt;

    @ApiModelProperty("出库单id")
    private Long odoDid;
}
