package com.elitesland.order.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 协同数据查询(SalDoD)查询结果对象
 *
 * @author fred
 * @since 2021-06-12 11:32:18
 */

@Data
@ApiModel(value = "SalDoLogisRespDTO", description = "协同数据查询-物流")
public class SalDoLogisRespDTO implements Serializable {
    private static final long serialVersionUID = -50351922551530415L;

    /**
     * 唯一id
     * 快递单号
     * 快递公司id
     * 店铺名称
     * 平台单据号
     * 发货单号
     * 地区
     * 发货单状态
     * 收货人
     * 收货人手机号
     * 收货地址
     * 备注
     * 创建日期
     *
     * 根据平台单号+物流单号去重
     */
    /**
     * 记录唯一ID-平台单号+物流单号
     */
    @ApiModelProperty("记录唯一ID-平台单号+物流单号")
    private String id;

    /**
     * 发货单ID
     */
    @ApiModelProperty("发货单ID")
    private Long doId;

    /**
     * 发货单编号
     */
    @ApiModelProperty("发货单编号")
    private String docNo;
    /**
     * 收货国家
     */
    @ApiModelProperty("收货国家")
    private String recvCountry;
    /**
     * 收货省份
     */
    @ApiModelProperty("收货省份")
    private String recvProvince;
    /**
     * 收货省份Name
     */
    @ApiModelProperty("收货省份Name")
    private String recvProvinceName;
    /**
     * 城市
     */
    @ApiModelProperty("城市(编号/ID)")
    private String recvCity;
    @ApiModelProperty("城市名称")
    private String recvCityName;
    /**
     * 区县
     */
    @ApiModelProperty("区县(编号/ID)")
    private String recvCounty;
    @ApiModelProperty("区县名称")
    private String recvCountyName;

    /**
     * 收货地址拼接
     */
    @ApiModelProperty("收货地址拼接")
    private String recvAddress;

    /**
     * 收货详细地址
     */
    @ApiModelProperty("收货详细地址")
    private String recvDetailaddr;
    /**
     * 销售组织id
     */
    @ApiModelProperty("销售组织id")
    private Long buId;

    /**
     * 销售组织name
     */
    @ApiModelProperty("销售组织name")
    private String buName;

    /**
     * 销售单号-SAL_SO
     */
    @ApiModelProperty("销售单号")
    private String relateDocNo;

    /**
     * 平台订单号
     */
    @ApiModelProperty("平台订单号")
    private String docNo2;

    /**
     * 订单创建日期
     */
    @ApiModelProperty("订单创建日期")
    private LocalDateTime createTime;

    /**
     * 收货联系人
     */
    @ApiModelProperty("收货联系人")
    private String recvContactName;
    /**
     * 收货联系电话
     */
    @ApiModelProperty("收货联系电话")
    private String recvContactTel;

    /**
     * 销售区域 [UDC]SAL:SAL_REGION
     */
    @ApiModelProperty("销售区域 [UDC]SAL:SAL_REGION")
    private String saleRegion;

    /**
     * 物流公司ID
     */
    @ApiModelProperty("物流公司ID")
    private Long logisCarrierId;

    /**
     * 物流公司ID
     */
    @ApiModelProperty("物流公司Name")
    private String logisCarrierName;

    /**
     * 物流公司ID
     */
    @ApiModelProperty("物流公司Code")
    private String logisCarrierCode;

    /**
     * 物流单号
     */
    @ApiModelProperty("物流单号")
    private String logisDocNo;
    /**
     * 发货单状态 [UDC]SAL:DO_STATUS
     */
    @ApiModelProperty("发货单状态 [UDC]SAL:DO_STATUS")
    private String docStatus;

    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建人")
    private String creator;

}
