package com.elitesland.order.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @Auther: Mark
 * @Date: 2023/12/13 14:05
 * @Description:
 */
@Data
@ApiModel(value = "SalLinetypeRespVO", description = "销售行类型")
public class SalLinetypeRespVO implements Serializable {
    private static final long serialVersionUID = -216646327207647876L;
    /**
     * 记录唯一ID
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    private Long ouId;
    /**
     * BUID
     */
    @ApiModelProperty("BUID")
    private Long buId;
    /**
     * 行类别
     */
    @ApiModelProperty("行类别")
    private String linetypeCls;
    /**
     * 行类型
     */
    @ApiModelProperty("行类型")
    private String lineType;
    /**
     * 行类型名称
     */
    @ApiModelProperty("行类型名称")
    private String linetypeName;
    /**
     * 发货策略 1=需要发货。0=不需要发货。在订单发货查询等界面，会读取这个值，决定这一行是不是需要发货。
     */
    @ApiModelProperty("发货策略 1=需要发货。0=不需要发货。在订单发货查询等界面，会读取这个值，决定这一行是不是需要发货。")
    private String deliverPolicy;
    /**
     * 服务工单策略 1=需要生成服务工单。0=不需要生成服务工单。生成服务工单时会用到这个值。
     */
    @ApiModelProperty("服务工单策略 1=需要生成服务工单。0=不需要生成服务工单。生成服务工单时会用到这个值。")
    private String servicePolicy;
    /**
     * 价格策略 1=有价格。0=0价格。0价格的在创建和编辑订单时，价格不需要获取，直接就是0，且不能修改。
     */
    @ApiModelProperty("价格策略 1=有价格。0=0价格。0价格的在创建和编辑订单时，价格不需要获取，直接就是0，且不能修改。")
    private String pricePolicy;
    /**
     * 生效日期
     */
    @ApiModelProperty("生效日期")
    private LocalDateTime validFrom;
    /**
     * 失效日期
     */
    @ApiModelProperty("失效日期")
    private LocalDateTime validTo;

    /**
     * 商品类型udc ITM:ITEM_TYPE
     */
    @ApiModelProperty("商品类型udc ITM:ITEM_TYPE")
    private String itemType;

}
