package com.elitesland.order.service;

import com.elitesland.order.Application;
import com.elitesland.order.param.*;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author Shadow
 * @since 2021-07-12 9:11
 */
@FeignClient(name = Application.NAME, path = Application.PATH + SalDoDRpcService.PATH)
@Validated
public interface SalDoDRpcService {

    String PATH = "/salDoDRpc";

    /**
     * 查询发货单
     *
     * @param salDoDQueryDTO 查询参数
     * @return 发货单
     */
    @PostMapping("/queryDodForInvoice")
    ApiResult<PagingVO<SalDoDRPCRespDTO>> queryDodForInvoice(@RequestBody SalDoDQueryDTO salDoDQueryDTO);


    /**
     * 从出库单 同步发货单明细信息，至发货单明细表中，
     * 包括明细的新增/修改
     * 同步发货物流信息，更新发货单状态
     */
    @PostMapping("/updateSalDod")
    ApiResult<List<SalDoDRespDTO>> updateSalDod(@RequestBody SalDoLogisRpcDTO salDoLogisRpcDTO);


    /**
     * 修改sal_do_d的核销金额，已经sal_so_d的核销金额，核销状态
     */
    @PostMapping("/updateVerAmt")
    ApiResult<List<SalDoDRespDTO>> updateVerAmt(@RequestBody List<SalDoDVerDTO> salDoDVerDTOList);

}
