package com.elitesland.order.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @Author: ryan.xu
 * @since 2023/12/20
 */
@Data
@ApiModel("物流签收参数DTO")
public class SalDoAutoSignParamDTO implements Serializable {
    private static final long serialVersionUID = 5451035327855567760L;

    @ApiModelProperty("物流单号")
    @NotBlank
    private String expressNo;

    @ApiModelProperty("签收状态：SIGN-签收，REJECT-拒收")
    @NotBlank
    private String signStatus;
}
