package com.elitesland.order.param;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @Author: ryan.xu
 * @since 2023/10/8
 */
@Data
public class SalDoSaveRpcDTO implements Serializable {
    private static final long serialVersionUID = 7422457961412348093L;

    /**
     * 记录唯一ID
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;

    @ApiModelProperty("发货单位")
    private Long ouId;

    /**
     * 发货单编号
     */
    @ApiModelProperty("发货单编号")
    private String docNo;
    /**
     * 单据类别 [UDC]COM:DOC_CLS
     */
    @ApiModelProperty("单据类别 [UDC]COM:DOC_CLS")
    private String docCls;
    /**
     * 单据类型 [UDC]SAL:DO_TYPE
     */
    @ApiModelProperty("单据类型 [UDC]SAL:DO_TYPE")
    private String docType;


    /**
     * 状态UDC
     */
    @ApiModelProperty("状态UDC")
    private String docStatus;
    /**
     * 订单类型
     */
    @ApiModelProperty("订单类型")
    private String relateDocType;
    /**
     * 销售单号
     */
    @ApiModelProperty("销售单号")
    private String relateDocNo;

    /**
     * 仓库id
     */
    @ApiModelProperty("仓库id")
    private Long whId;
    /**
     * 限定2
     */
    @ApiModelProperty("限定2")
    private String deter2;

    /**
     * 发货单日期
     */
    @ApiModelProperty("发货单日期")
    private LocalDateTime docDate;
    /**
     * 发货时间
     */
    @ApiModelProperty("发货时间")
    private LocalDateTime docTime;
    /**
     * 客户ID
     */
    @ApiModelProperty("客户ID")
    private Long custId;
    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    private String custName;
    /**
     * 客户编码
     */
    @ApiModelProperty("客户编码")
    private String custCode;
    /**
     * 订单日期
     */
    @ApiModelProperty("订单日期")
    private LocalDate salDocDate;
    /**
     * 配送方式
     */
    @ApiModelProperty("配送方式")
    private String deliverMethod;
    @ApiModelProperty("配送方式Name")
    private String deliverMethodName;
    /**
     * 承运商信息
     */
    @ApiModelProperty("承运商信息")
    private String carrier;
    /**
     * 业务员id
     */
    @ApiModelProperty("业务员id")
    private Long agentEmpId;
    /**
     * 收货地址号
     */
    @ApiModelProperty("收货地址号")
    private Long recvAddrNo;

    /**
     * 收货联系人
     */
    @ApiModelProperty("收货联系人")
    private String recvContactName;
    /**
     * 收货联系电话
     */
    @ApiModelProperty("收货联系电话")
    private String recvContactTel;

    /**
     * 收货国家
     */
    @ApiModelProperty("收货国家")
    private String recvCountry;
    /**
     * 收货省
     */
    @ApiModelProperty("收货省")
    private String recvProvince;
    /**
     * 收货市
     */
    @ApiModelProperty("收货市")
    private String recvCity;
    /**
     * 收货区县
     */
    @ApiModelProperty("收货区县")
    private String recvCounty;
    /**
     * 收货乡镇街道
     */
    @ApiModelProperty("收货乡镇街道")
    private String recvStreet;

    /**
     * 送货地址
     */
    @ApiModelProperty("送货地址")
    private String recvDetailaddr;
    /**
     * 一件代发(是否供应商代发)
     */
    @ApiModelProperty("一件代发(是否供应商代发)")
    private String suppFlag;
    /**
     * 供应商id
     */
    @ApiModelProperty("供应商id")
    private Long suppId;
    /**
     * 要求交货日期
     */
    @ApiModelProperty("要求交货日期")
    private LocalDateTime demandDate;

    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remark;

    /**
     * 关联单据ID So_ID
     */
    @ApiModelProperty("关联单据ID So_ID")
    private Long relateDocId;

    /**
     * 签收日期
     */
    @ApiModelProperty("签收日期")
    private LocalDateTime confirmTime;
    /**
     * 签收用户ID
     */
    @ApiModelProperty("签收用户ID")
    private Long confirmUserId;
    /**
     * 签收人
     */
    @ApiModelProperty("签收人")
    private String confirmName;

    /**
     * 附件code
     */
    @ApiModelProperty("附件code")
    private String fileCode;
    /**
     * 单据类型3
     */
    @ApiModelProperty("单据类型3")
    private String docType3;
    /**
     * 销售组织id
     */
    @ApiModelProperty("销售组织id")
    private Long buId;
    /**
     * 单据类型2 [UDC]SAL:SO_TYPE2
     */
    @ApiModelProperty("单据类型2 [UDC]SAL:SO_TYPE2")
    private String docType2;
    /**
     * 关联单据类别 SO。[UDC]COM:DOC_CLS
     */
    @ApiModelProperty("关联单据类别 SO。[UDC]COM:DOC_CLS")
    private String relateDocCls;
    /**
     * 关联单据2类别 [UDC]COM:DOC_CLS
     */
    @ApiModelProperty("关联单据2类别 [UDC]COM:DOC_CLS")
    private String relateDoc2Cls;
    /**
     * 关联单据2类型
     */
    @ApiModelProperty("关联单据2类型")
    private String relateDoc2Type;
    /**
     * 关联单据2ID
     */
    @ApiModelProperty("关联单据2ID")
    private Long relateDoc2Id;

    @ApiModelProperty("关联单据2单号")
    private String relateDoc2No;

    /**
     * 关联单据类别 来源采购订单等。[UDC]COM:DOC_CLS
     */
    @ApiModelProperty("来源单据类别 来源采购订单等。[UDC]COM:DOC_CLS")
    private String rootDocCls;
    /**
     * 关联单据类型
     */
    @ApiModelProperty("来源单据类型")
    private String rootDocType;
    /**
     * 关联单据ID
     */
    @ApiModelProperty("来源单据ID")
    private Long rootDocId;
    /**
     * 关联单据编号
     */
    @ApiModelProperty("来源单据编号")
    private String rootDocNo;
    /**
     * sec_bu_id
     */
    @ApiModelProperty("sec_bu_id")
    private Long secBuId;

    /**
     * sec_user_id
     */
    @ApiModelProperty("sec_user_id")
    private Long secUserId;

    /**
     * sec_ou_id
     */
    @ApiModelProperty("sec_ou_id")
    private Long secOuId;
    /**
     * 仓库ID
     */
    @ApiModelProperty("仓库ID")
    private Long recvWhId;
    /**
     * 收方限定2
     */
    @ApiModelProperty("收方限定2")
    private String recvDeter2;

    @ApiModelProperty("操作人id")
    private Long createUserId;
    /**
     * 记录创建者
     */
    @ApiModelProperty("记录创建者")
    private String creator;

    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    /**
     * 记录最后更新者ID
     */
    @ApiModelProperty("记录最后更新者ID")
    private Long modifyUserId;
    /**
     * 记录最后更新者
     */
    @ApiModelProperty("记录最后更新者")
    private String updater;

    @ApiModelProperty("修改时间")
    private LocalDateTime modifyTime;

    @ApiModelProperty("预约时间段")
    private String appointTime;

    @ApiModelProperty("主客户编号")
    private String preCustCode;

    @ApiModelProperty("主客户名称")
    private String preCustName;

    @ApiModelProperty("客户渠道")
    private String saleChannel;

    @ApiModelProperty("记账日期")
    private LocalDateTime finDate;

    @ApiModelProperty("付款条款")
    private String paymentTerm;
    private String paymentTermName;

    @ApiModelProperty("是否补单")
    private Boolean ioFlag;

    @ApiModelProperty("是否事物账单补单")
    private Boolean interFlag;

    @ApiModelProperty("门店编码")
    private String storeCode;

    @ApiModelProperty("门店名")
    private String storeName;

    @ApiModelProperty("门店ID")
    private Long storeId;

    @ApiModelProperty("根单据下单时间")
    private LocalDateTime rootDocTime;

    @ApiModelProperty(value = "成本中心编码")
    private String costCenterCode;


    @ApiModelProperty("销售出库单明细")
    private List<SalDoDSaveRpcDTO> salDoDSaveRpcDTOList;

}
