package com.elitesland.order.param;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.List;


/**
 * 退货收货单(SalDoDO)保存参数(团内退货&旧件返还业务)
 *
 * @author dave
 * @since 2022-02-22
 */

@Data
@ApiModel(value = "SalDoReturnSaveDTO", description = "退货收货单保存参数(团内退货&旧件返还业务)")
public class SalDoReturnSaveDTO implements Serializable {
    private static final long serialVersionUID = 6889443943743805463L;

    /**
     * 采购退货登记单号
     */
    @ApiModelProperty("采购退货登记单号")
    @NotBlank(message = "请输入采购退货登记单号！")
    private String relateDoc3No;

    /**
     * 采购退货登记单id
     */
    @ApiModelProperty("采购退货登记单id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDoc3Id;

    /**
     * 采购退货订单号
     */
    @ApiModelProperty("采购退货订单号")
    @NotBlank(message = "请输入采购退货订单号！")
    private String rootDocNo;

    /**
     * 采购退货订单id
     */
    @ApiModelProperty("采购退货登记单id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long rootDocId;

    /**
     * 明细list
     */
    @ApiModelProperty("明细list")
    private List<SalDoReturnDetailSaveDTO> list;

}