package com.elitesland.order.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author fred
 * B端商城的签收参数
 */
@Data
@ApiModel(value = "SalSoSignReqDto", description = "B端商城的签收参数")
public class SalSoSignReqDto implements Serializable {

    private static final long serialVersionUID = -3816285065494126804L;
    /**
     * 订单编号
     */
    @ApiModelProperty("订单编号")
    private String docNo;
    /**
     * 签收人信息
     */
    @ApiModelProperty("签收人信息")
    private SalDoSignUserInfoDto salDoSignUserInfoDto;

    /**
     * 附件code 数组
     */
    @ApiModelProperty("附件code 数组")
    private List<String> fileCodes;


}
