package com.elitesland.order.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.order.Application;
import com.elitesland.order.param.OpenSalSoQueryDTO;
import com.elitesland.order.param.OpenSalSoRespDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 发货单对外提供服务接口
 *
 * @author fred
 * @date 2021-05-31
 */
@FeignClient(name = Application.NAME, path = Application.PATH + OpenSalSoRpcService.URI)
public interface OpenSalSoRpcService {

    String URI = "/salSo";


    @PostMapping("/querySalSoList")
    ApiResult<PagingVO<OpenSalSoRespDTO>> querySalSoList(@RequestBody OpenSalSoQueryDTO param);


}
