package com.elitesland.sale.api.vo.save;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;


/**
 * @author : http://www.chiner.pre
 * @date : 2023-4-12
 * @desc : 执行记录明细表
 */
@Data
@ApiModel(description = "执行记录明细表")
public class ExecutRecordDtlSaveVO implements Serializable {
    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("关联id")
    private Long masId;

    @ApiModelProperty("进店时间")
    private LocalDateTime entryTime;

    @ApiModelProperty("离店时间")
    private LocalDateTime leaveTime;

    @ApiModelProperty("签到地点")
    private String signInPosition;

    @ApiModelProperty("签到地点编码")
    private String signInPositionCode;

    @ApiModelProperty("签退地点")
    private String signOutPosition;

    @ApiModelProperty("签退地点编码")
    private String signOutPositionCode;

    @ApiModelProperty("签到备注")
    private String signDesc;

    @ApiModelProperty("记录模板附件")
    private List<ExectRecordDtlTempSaveVO> tempDtlSaveVOS;

    @ApiModelProperty("附件集合")
    private List<FileInfoSaveVO> fileInfoSaveVOS;

}