package com.elitesland.sale.api.vo.save.shop;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021/10/10
 */
@Data
@ApiModel(description = "商品SKU价格信息")
public class BipItemSkuPriceUpdateVO implements Serializable {
    private static final long serialVersionUID = -47529699159777744L;

    @ApiModelProperty(value = "SKU的ID", position = 1, required = true)
    @NotNull(message = "SKU的ID为空")
    private Long skuId;

    @ApiModelProperty(value = "新的基础价", position = 2, required = true)
    @NotNull(message = "价格不能为空")
    private BigDecimal price;
}
