package com.elitesland.sale.api.vo.save.shop;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021/08/17
 */
@Data
@ApiModel(description = "商品分类保存信息")
public class BipItemCategorySaveVO implements Serializable {
    private static final long serialVersionUID = -1442079588065512544L;

    @ApiModelProperty(value = "上级分类ID，顶级分类可为空", position = 1)
    private Long pid;

    @ApiModelProperty(value = "分类编号", required = true, position = 2)
    @NotBlank(message = "分类编号不能为空")
    @Size(min = 1, max = 20, message = "分类编号的长度限制为1 ~ 20")
    private String code;

    @ApiModelProperty(value = "分类名称", required = true, position = 3)
    @NotBlank(message = "分类名称不能为空")
    @Size(min = 1, max = 20, message = "分类名称的长度限制为1 ~ 20")
    private String name;

    @ApiModelProperty(value = "序号", required = true, position = 4)
    @NotNull(message = "序号不能为空")
    private Integer sortNo;

    @ApiModelProperty(value = "是否启用，默认否", position = 5)
    private Boolean enable;

    @ApiModelProperty(value = "分类图片，三级分类需要", position = 6)
    private String picFileCode;

    @ApiModelProperty(value = "所属公司ID", required = true, position = 7)
    @NotNull(message = "用户所属公司不能为空")
    private Long ouId;
}
