package com.elitesland.sale.api.vo.save.shop;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/09/22/10:59
 * @Description:
 */

@Data
@ApiModel(value = "BipAppOrderSaveVO", description = "订单生成参数")
public class BipAppOrderSaveVO implements Serializable {

    private static final long serialVersionUID = 7765214780559204650L;
    @ApiModelProperty(value = "购物车ID")
    private List<Long> cartIds;

    @ApiModelProperty(value = "ouId")
    private Long ouId;

    @ApiModelProperty(value = "商品id")
    private Long itemId;

    @ApiModelProperty(value = "商品数量")
    private Long itemNum;

    @ApiModelProperty(value = "skuId")
    private Long skuId;

    @ApiModelProperty(value = "收货地址ID")
    private Long addressId;

    @ApiModelProperty(value = "是否开票")
    private Boolean invoice;

    @ApiModelProperty(value = "付款方式")
    private String payWay;

    @ApiModelProperty(value = "优惠券id")
    private Long couponId;

    @ApiModelProperty(value = "微信认证code")
    private String  code;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("是否首单商品 true是  false不是")
    private Boolean firstItemFlag;

    @ApiModelProperty("赠品信息")
    private List<Map<Long, List<String>>> giftIdList;

}
