package com.elitesland.sale.api.service.shop;

import com.elitesland.sale.api.vo.param.shop.BipAddressCreateParam;
import com.elitesland.sale.api.vo.param.shop.BipAddressUpdateParam;
import com.elitesland.sale.api.vo.resp.shop.BipAddressVO;

import java.util.List;

/**
 * @author Joker (Xing Shixiang)
 * @create 2021-09-01 14:52
 */
public interface BipAddressService {
    /**
     * 新增一条收货地址
     * @param param 新增一条收货地址的入参
     * @return 新增数据的id
     */
    Long createAddress (BipAddressCreateParam param);

    /**
     * 删除收货地址
     * @param id 要删除收货地址的ID
     * @return 已删除收货地址的ID
     */
    Long deleteAddressById(Long id);

    /**
     * 更新一个收货地址
     * @param param 更新一个收货地址的入参
     * @return 更新一个收货地址的ID
     */
    Long updateAddress (BipAddressUpdateParam param);


    /**
     * @param id 地址id
     * @return BipAddressVO 地址信息
     */
    BipAddressVO findById (Long id);

    /**
     * 查询一个该用户名下的收货地址
     * @return 该用户名下的收货地址  --顺序默认的最上边  后由早到晚依次
     */
    List<BipAddressVO> findByAccountId ();

    /**
     * 更改用户的默认地址
     * @param id 收货地址ID
     * @return 新默认收货地址的ID
     */
    Long updateDefaultById (Long id);
}
