package com.elitesland.sale.api.vo.resp.crm;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
@ApiModel(value = "客户基本信息", description = "客户基本信息")
public class CustBaseDTO implements Serializable {
    private static final long serialVersionUID = 7750485941817044771L;

    /**
     * 客户ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "客户ID")
    private Long id;

    /**
     * 客户编码
     */
    @ApiModelProperty(value = "客户编码")
    private String custCode;

    /**
     * 客户名称
     */
    @ApiModelProperty(value = "客户名称")
    private String custName;

    private String custGroup;

    @ApiModelProperty(value = "客户号")
    private String custCode2;

    @ApiModelProperty(value = "地址号")
    private Long addrNo;

    @ApiModelProperty("客户类别")
    private String custType;

    @ApiModelProperty("区域")
    private String region;

    @ApiModelProperty(value = "客户等级")
    private String custLevel;

    /**
     * 客户简称
     */
    @ApiModelProperty(value = "客户简称")
    private String custAbbr;

    /**
     * 联系人电话
     */
    @ApiModelProperty(value = "联系人电话")
    private String contactPhone;

    /**
     * 联系人姓名
     */
    @ApiModelProperty(value = "联系人姓名")
    private String contactName;


    @ApiModelProperty(value = "客户状态")
    private String custStatus;

    @ApiModelProperty(value = "客户渠道")
    private String saleChannel;

    @ApiModelProperty(value = "业务员ID")
    private Long agentEmpId;

    @ApiModelProperty("付款条款")
    private String paymentTerm;

    @ApiModelProperty("客户定义")
    private String custDef;

    @ApiModelProperty("主客户编码")
    private String preCustCode;

    @ApiModelProperty("客户组编码")
    private String cat10;

    @ApiModelProperty("客户组名称")
    private String cat11;

    @ApiModelProperty("内外部客户")
    private String inOutCust;


    @ApiModelProperty(value = "客户归类")
    private String custType2;

    @ApiModelProperty("关联公司编码")
    private String corBusinCode;

}
