package com.elitesland.sale.api.vo.resp.sal;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/6/15 20:08
 */
@ApiModel(description = "销售报销单明细")
@Data
public class SalQuotationDRespVO implements Serializable {
    private static final long serialVersionUID = -8828277657891485162L;

    @ApiModelProperty(value = "销售报销单明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty(value = "行号")
    private BigDecimal lineNo;

    @ApiModelProperty(value = "销售报销单主表ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long masId;

    @ApiModelProperty(value = "商品ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty(value = "商品编码")
    private String itemCode;

    @ApiModelProperty(value = "商品名称")
    private String itemName;

    @ApiModelProperty(value = "商品规格")
    private String itemSpec;

    @ApiModelProperty(value = "品牌")
    private String itemBrand;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "要求发货日期")
    private LocalDateTime demandTimespan;

    @ApiModelProperty(value = "数量")
    private Long qty;

    @ApiModelProperty(value = "计量单位 [UDC]COM:UOM")
    @SysCode(sys = "yst-supp",mod = "UOM")
    private String uom;
    private String uomName;

    @ApiModelProperty(value = "未税单价")
    private BigDecimal netPrice;

    @ApiModelProperty(value = "未税金额")
    private BigDecimal netAmt;

    @ApiModelProperty(value = "含税单价")
    private BigDecimal price;

    @ApiModelProperty(value = "含税金额")
    private BigDecimal amt;

    @ApiModelProperty(value = "税额")
    private BigDecimal taxAmt;

    @ApiModelProperty(value = "税率")
    private BigDecimal taxRate;

    @ApiModelProperty(value = "税率编码")
    private String taxRateNo;

    @ApiModelProperty(value = "税率描述")
    private String taxRateDesc;

    @ApiModelProperty(value = "折扣率")
    private BigDecimal discRatio;

    @ApiModelProperty(value = "折扣金额")
    private BigDecimal discAmt;

    @ApiModelProperty(value = "原始价格(基础价格)")
    private BigDecimal priceOrig;

    @ApiModelProperty(value = "行类型")
    private String lineType;

}
