package com.elitesland.sale.api.vo.resp.taskinfo;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.sale.api.vo.resp.BaseModelVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * @author : WWW
 * @date : 2023-5-19
 * @desc : 销售业绩统计-门店-明细
 */
@Data
@ApiModel(description = "销售业绩统计-门店-明细")
public class SaleStatisticsStoreDtlRespVO extends BaseModelVO {

    /**
     * 关联id
     */
    @ApiModelProperty("关联id")
    private Long masId;

    /**
     * 层级：  0——默认是客户所属的业务员  1、2、...——依次往上查询上级赋值
     */
    @ApiModelProperty("层级：  0——默认是客户所属的业务员  1、2、...——依次往上查询上级赋值")
    private String level;

    /**
     * 业务员编码
     */
    @ApiModelProperty("业务员编码")
    private String code;

    /**
     * 业务员名称
     */
    @ApiModelProperty("业务员名称")
    private String name;

    @ApiModelProperty("类型")
    @SysCode(sys = "yst-sale", mod = "SALESMAN_TYPE")
    private String type;
    private String typeName;


}