package com.elitesland.sale.dto;

import io.swagger.annotations.ApiModel;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 返回参数 - 对外销售价查询
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/6/1 2:04 下午
 */
@Data
@ApiModel(value = "PriSalePriceRespDTO", description = "对外销售价查询返回参数")
public class PriSalePriceDTO implements Serializable {

    private static final long serialVersionUID = 6089549409821476252L;

    /**
     * 公司ID
     */
    private Long ouId;

    /**
     * 客户ID
     */
    private Long custId;
    private String custCode;

    /**
     * 价格结果列表
     */
    private List<PriSalePriceSimpleDTO> priceList;
}
