package com.elitesland.sale.service;

import com.elitesland.sale.Application;
import com.elitesland.sale.dto.query.SalInvApplyCheckDTO;
import com.elitesland.sale.dto.query.SalReceiptCheckDTO;
import com.elitescloud.cloudt.common.base.ApiResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * @auther JinXK
 * @date 2021/8/26 11:08
 */
@FeignClient(name = Application.NAME, path = SalReceiptRpcService.URI)
public interface SalReceiptRpcService {
    String URI = Application.URI_PREFIX + "/receipt";
	@PostMapping("/salReceiptRpc/updateReceiptStatus")
    ApiResult<Object> updateReceiptStatus(SalReceiptCheckDTO receiptCheckDTO);

	@PostMapping("/salReceiptRpc/updateInvApplyStatus")
    ApiResult<Object> updateInvApplyStatus(SalInvApplyCheckDTO salInvApplyCheckDTO);
}
