package com.elitesland.sale.api.vo.param.itm;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
@ApiModel(description = "上架sku查询参数")
public class OnShelfSkuQueryParam extends AbstractOrderQueryParam {

    private static final long serialVersionUID = -342134888451302842L;

    @ApiModelProperty(value = "发货基地id")
    private Long desId;

    @ApiModelProperty(value = "销售渠道")
    private String channelType;

    @ApiModelProperty("skuId集合")
    private List<Long> skuIds;

    @ApiModelProperty("商品类型，整车、配件、广宣品、附件包")
    private String itemType2;

    @ApiModelProperty("整车/配件类型，取决于itemType2")
    private String itemType3;

    @ApiModelProperty("商品名称，模糊搜索")
    private String itemName;
}
