package com.elitesland.sale.api.vo.param.sal;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @auther JinXK
 * @date 2021/6/2 14:47
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(description = "销售开票申请分页查询请求参数")
public class SalInvApplyPageParam extends AbstractOrderQueryParam implements Serializable {
    private static final long serialVersionUID = -8320150570583071009L;

    @ApiModelProperty(value = "主键ID")
    private Long id;

    @ApiModelProperty(value = "合同编号")
    private String contractCode;

    @ApiModelProperty(value = "合同名称")
    private String contractName;

    @ApiModelProperty(value = "客户编号")
    private String custCode;

    @ApiModelProperty(value = "客户名称")
    private String custName;

    @ApiModelProperty(value = "预计到款日期-start")
    private LocalDateTime planReceiptDateStart;

    @ApiModelProperty(value = "预计到款日期-end")
    private LocalDateTime planReceiptDateEnd;

    @ApiModelProperty(value = "订单编号")
    private String soNo;

    @ApiModelProperty(value = "销售公司编号")
    private String ouCode;

    @ApiModelProperty(value = "申请日期-start")
    private LocalDateTime applyDateStart;

    @ApiModelProperty(value = "申请日期-end")
    private LocalDateTime applyDateEnd;

    @ApiModelProperty(value = "单据类型")
    private String docType;

    @ApiModelProperty(value = "单据状态")
    private String docStatus;

    @ApiModelProperty(value = "单据编号")
    private String docNo;

    @ApiModelProperty(value = "销售区域")
    private String saleRegion;

    @ApiModelProperty(value = "蓝票/红票 [UDC]FIN:OPEN_TYPE")
    private String openType;
}
