package com.elitesland.sale.api.vo.resp.pri;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 价格变更申请单分页信息
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/5/26 10:49 上午
 */
@ApiModel(description = "价格变更申请单分页信息")
@Data
public class PriSalePriceAlterPageRespVO implements Serializable {
    private static final long serialVersionUID = -1975773199957074885L;

    @ApiModelProperty(value = "申请单ID")
    private Long id;

    @ApiModelProperty(value = "公司ID")
    private Long ouId;

    @ApiModelProperty(value = "公司名称")
    private String ouName;

    @ApiModelProperty(value = "申请单号")
    private String docNo;

    @ApiModelProperty(value = "类型 [UDC]PRI:SALE_PRICE_TYPE")
    @SysCode(sys = "PRI", mod = "SALE_PRICE_TYPE")
    private String docType;
    private String docTypeName;

    @ApiModelProperty(value = "状态 [UDC]PRI:SALE_APPLY_STATUS")
    @SysCode(sys = "PRI", mod = "SALE_APPLY_STATUS")
    private String docStatus;
    private String docStatusName;

    @ApiModelProperty(value = "申请人ID")
    private Long applyEmpId;

    @ApiModelProperty(value = "申请人")
    private String applyUserName;

    @ApiModelProperty(value = "申请时间")
    private LocalDateTime applyDate;

}
