package com.elitesland.sale.api.vo.resp.itm;

import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

/**
 * es专用
 *
 * @author : 常浩波
 * @date 2023/03/08
 */
@Data
public class ItmItemEsVO implements Serializable {
    private static final long serialVersionUID = -3142050555815983567L;
    /****************************************************下面是spu信息*****************************************************/
    /**
     * spu上架ID = channelType_desId_spuId
     */
    private String spuOnShelfId;

    /**
     * 销售渠道
     */
    private String channelType;
    /**
     * 发货基地
     */
    private Long desId;
    /**
     * 发货基地编码
     */
    private String desCode;
    /**
     * 发货基地名称
     */
    private String desName;
    /**
     * spuId
     */
    private Long spuId;

    /**
     * SPU编号
     */
    private String spuCode;

    /**
     * SPU名称
     */
    private String spuName;

    /**
     * 品类编号
     */
    private String itemCateCode;

    /**
     * 商品类型 [UDC]ITM:ITEM_TYPE2
     */
    private String itemType2;
    private String itemType2Name;

    /**
     * 整车/配件类型
     */
    private String itemType3;
    private String itemType3Name;

    /**
     * 车型 [UDC]ITM:ITEM_TYPE5
     */
    private String itemType5;
    private String itemType5Name;

    /**
     * 系列
     */
    private String itemGroup;

    /**
     * 产地/原产国，udc[yst-supp:ORIGIN]
     */
    private String origin;
    private String originName;

    /**
     * 排序配置
     * sortConfig:
     * all: num
     * specialAreas:
     * hn: num
     * xj: num
     * specialCusts:
     * custCode1: num
     * custCode2: num
     * <p>
     * num * 10000 * 10000
     * num * 10000
     * num
     * 0
     */
    private Map<String, Object> sortConfig;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 详细描述
     */
    private String itemDescribe;

    /**
     * spu图片
     */
    private List<ItmItemAttachmentRespVO> spuImages;

    /**
     * spu描述属性，属性name为key，属性value为value
     */
    private Map<String, String> itemPropVosMap;

    /****************************************************下面是sku信息*****************************************************/

    private Long id;

    /**
     * SKU商品编号
     */
    private String itemCode;

    /**
     * 商品规格(JSON格式)
     * [{"code":"200007","name":"尺码","value":"1"}]
     */
    private String itemAttr;

    /**
     * itemAttr转map
     */
    private Map<String, String> itemAttrMap;

    /**
     * SKU商品名称
     */
    private String itemName;

    /**
     * 条码
     */
    private String barCode;

    /**
     * 规格型号
     */
    private String spec;

    /**
     * sku图片名称
     */
    private String skuImageFileName;

    /**
     * sku图片fileCode
     */
    private String skuImageFileCode;

    /**
     * 即将下架日期
     */
    private LocalDateTime expRemovx;

    /**
     * SKU 图片
     */
    private List<ItmItemAttachmentRespVO> skuImages;

}
