package com.elitesland.sale.api.vo.resp.pro;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 返回参数 - 销售合同明细信息
 * @author Eric.li (Li Jia Zhe)
 * @date 2021-06-09 13:57:24
 */
@ApiModel(description = "销售合同明细信息")
@Data
public class SalContractDDetailRespVO implements Serializable {
    private static final long serialVersionUID = -2631896826079168251L;

    @ApiModelProperty("明细行Id")
    private Long id;

    @ApiModelProperty("主表ID")
    private Long masId;

    @ApiModelProperty("行号")
    private BigDecimal lineNo;

    @ApiModelProperty("商品ID")
    private Long itemId;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("商品规格")
    private String itemSpec;

    @ApiModelProperty("客户商品编码")
    private String custItemCode;

    @ApiModelProperty("商品品牌")
    private String itemBrand;
    private String itemBrandName;

    @ApiModelProperty("是否供应商直发")
    private Boolean suppFlag;

    @ApiModelProperty("数量")
    private BigDecimal qty;

    @ApiModelProperty(value = "计量单位 [UDC]COM:UOM")
    @SysCode(sys = "yst-supp",mod = "UOM")
    private String uom;
    private String uomName;

    @ApiModelProperty("未税价格")
    private BigDecimal netPrice;

    @ApiModelProperty("未税金额")
    private BigDecimal netAmt;

    @ApiModelProperty("含税价格")
    private BigDecimal price;

    @ApiModelProperty("含税金额")
    private BigDecimal amt;

    @ApiModelProperty("税额")
    private BigDecimal taxAmt;

    @ApiModelProperty("税率编号")
    private String taxRateNo;

    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("税率编号")
    private String taxRateDesc;

    @ApiModelProperty("折扣率")
    private BigDecimal discRatio;

    @ApiModelProperty("折扣含税额")
    private BigDecimal discAmt;

    @ApiModelProperty("折扣不含税额")
    private BigDecimal discNetAmt;

    @ApiModelProperty("运输方式")
    @SysCode(sys = "yst-supp", mod = "TP_TYPE")
    private String transType;
    private String transTypeName;

    @ApiModelProperty("基础价格")
    private BigDecimal basePrice;

    @ApiModelProperty("单个净重")
    private BigDecimal signNetWeight;

    @ApiModelProperty("总净重")
    private BigDecimal netWeight;

    @ApiModelProperty("单个毛重")
    private BigDecimal signGrossWeight;

    @ApiModelProperty("总毛重")
    private BigDecimal grossWeight;

    @ApiModelProperty("重量单位")
    private String weightUom;

    @ApiModelProperty("单个体积")
    private BigDecimal signVolume;

    @ApiModelProperty("总体积")
    private BigDecimal volume;

    @ApiModelProperty("体积单位")
    private String volumeUom;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("合同订单数量")
    private BigDecimal orderNumber;
}
