package com.elitesland.sale.api.vo.resp.sal;


import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 业绩提成规则(SalCommissionRule)实体类
 *
 * @author makejava
 * @since 2021-11-22 17:51:06
 */

@Data
@ApiModel(value = "sal_commission_rule", description = "业绩提成规则")
public class SalCommissionRuleVO implements Serializable {
    private static final long serialVersionUID = 935951476366336636L;
    /**
     * 记录唯一ID
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    private Long ouId;
    /**
     * 公司编号
     */
    @ApiModelProperty("公司编号")
    private String ouCode;
    /**
     * 公司名称
     */
    @ApiModelProperty("公司名称")
    private String ouName;
    /**
     * 商品品类编号
     */
    @ApiModelProperty("商品品类编号")
    private String itemCateCode;

    @ApiModelProperty("品类编号")
    private String cateCodeName;

    @ApiModelProperty("品类数组")
    private List<Category> categories;
    /**
     * 商品ID
     */
    @ApiModelProperty("商品ID")
    private Long itemId;
    /**
     * 商品编号
     */
    @ApiModelProperty("商品编号")
    private String itemCode;
    /**
     * 商品名称
     */
    @ApiModelProperty("商品名称")
    private String itemName;
    /**
     * 提成规则 UDC:SAL/COMMISSION_RULE
     */
    @ApiModelProperty("提成规则 UDC:SAL/COMMISSION_RULE")
    private String commissionRule;

    private String commissionRuleName;
    /**
     * 提成百分比
     */
    @ApiModelProperty("提成百分比")
    private BigDecimal percentage;
    /**
     * 计件提成每件提成（元）
     */
    @ApiModelProperty("计件提成每件提成（元）")
    private BigDecimal pieceWage;

    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty("创建日期")
    private String createDate;

    @ApiModelProperty(value = "创建人姓名")
    private String creator;

    @Data
    public static class Category implements Serializable{
        private static final long serialVersionUID = 6767166459851912675L;
        private String code;
        private String name;
    }

}
