package com.elitesland.sale.api.vo.resp.taskinfo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/06/13
 * @Version 1.0
 * @Content:
 */
@Data
@ApiModel(description = "APP端经销商销售业绩汇总使用出参")
public class StatisticsDealerAppSumRespVO implements Serializable {
    private static final long serialVersionUID = 7184934156947281777L;

    @ApiModelProperty(value = "业务员编码")
    private String agentEmpCode;
    @JsonIgnore
    @ApiModelProperty("汇总出货量")
    private BigDecimal shipTotalQty;
    @ApiModelProperty("汇总订货量")
    @JsonIgnore
    private BigDecimal orderTotalQty;

    @ApiModelProperty("团队汇总出货量")
    private BigDecimal teamShipTotalQty;

    @ApiModelProperty("团队汇总订货量")
    private BigDecimal teamOrderTotalQty;

    @ApiModelProperty("我的汇总出货量")
    private BigDecimal myShipTotalQty;

    @ApiModelProperty("我的汇总订货量")
    private BigDecimal myOrderTotalQty;
}
