package com.elitesland.sale.api.vo.save;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.alibaba.excel.converters.bigdecimal.BigDecimalBooleanConverter;
import com.elitesland.sale.api.vo.convert.StringLocalDateTimeConverter;
import io.swagger.annotations.ApiModelProperty;
import jodd.typeconverter.impl.LocalDateConverter;
import lombok.Data;

import javax.persistence.Converter;
import java.io.Serializable;
import java.time.LocalDateTime;

@Data
public class CrmMajorCustImportVO  implements Serializable {
    
    private final String custDefName = "主客户";
    private String custDef;
    
    @ApiModelProperty(value = "客户归类")
    @ExcelProperty(index = 0)
    private String custType2Name;
    private String custType2;
    
    @ApiModelProperty(value = "主客户编码")
    @ExcelProperty(index = 1)
    private String custCode;
    
    @ApiModelProperty(value = "主客户名称")
    @ExcelProperty(index = 2)
    private String custName;
    
    @ApiModelProperty(value = "客户类型")
    @ExcelProperty(index = 3)
    private String custTypeName;
    private String custType;
    
    @ApiModelProperty(value = "统一社会信用代码")
    @ExcelProperty(index = 4)
    private String certNo;
    
    @ApiModelProperty(value = "客户简称")
    @ExcelProperty(index = 5)
    private String custAbbr;
    
    @ApiModelProperty("法人代表")
    @ExcelProperty(index = 6)
    private String repr;
    
    @ApiModelProperty("法人联系方式")
    @ExcelProperty(index = 7)
    private String reprCertMobile;
    
    @ApiModelProperty(value = "发票类型 [UDC]COM:INV_TYPE")
    @ExcelProperty(index = 8)
    private String invTypeName;
    private String invType;
    
    @ApiModelProperty(value = "开票抬头")
    @ExcelProperty(index = 9)
    private String invTitle;
    
    @ApiModelProperty(value = "税号")
    @ExcelProperty(index = 10)
    private String taxerNo;
    
    @ApiModelProperty(value = "开票地址")
    @ExcelProperty(index = 11)
    private String invAddress;
    
    @ApiModelProperty(value = "开票电话")
    @ExcelProperty(index = 12)
    private String invTel;
    
    @ApiModelProperty(value = "开户银行")
    @ExcelProperty(index = 13)
    private String invBankName;
    
    @ApiModelProperty(value = "银行账户")
    @ExcelProperty(index = 14)
    private String invBankAcc;
    
    @ApiModelProperty(value = "开票联系人")
    @ExcelProperty(index = 15)
    private String invPicName;
    
    @ApiModelProperty("开票联系人电话")
    @ExcelProperty(index = 16)
    private String invPicPhone;
    
    @ApiModelProperty(value = "证照编号")
    @ExcelProperty(index = 17)
    private String qualifyNo;
    
    @ApiModelProperty(value = "证照类型")
    @ExcelProperty(index = 18)
    private String qualifyTypeName;
    
    @ApiModelProperty(value = "生效日期")
    @ExcelProperty(index = 19, converter = StringLocalDateTimeConverter.class)
    private LocalDateTime validFrom;
    
    @ApiModelProperty(value = "失效日期")
    @ExcelProperty(index = 20, converter = StringLocalDateTimeConverter.class)
    private LocalDateTime validTo;
    
    @ApiModelProperty(value = "公司编号")
    @ExcelProperty(index = 21)
    private String ouCode;
    
    @ApiModelProperty("是否是通用客商")
    @ExcelProperty(index = 22)
    private String es3;
}