package com.elitesland.sale.api.vo.param.shop;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;


/**
 * 发票明细表(BipInv)查询入参
 *
 * @author Joker (Xing Shixiang)
 * @since 2021-09-06 13:51:25
 */

@Data
@ApiModel(value = "bip_inv", description = "发票明细表查询入参")
public class BipInvQueryParam extends AbstractOrderQueryParam {
    private static final long serialVersionUID = 260491637155963915L;
    /**
     * 记录唯一ID
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 订单ID
     */
    @ApiModelProperty("订单号")
    private String docNo;
    /**
     * 抬头类型
     */
    @ApiModelProperty("抬头类型")
    private String invTitleType;
    /**
     * 企业地址
     */
    @ApiModelProperty("企业地址")
    private String companyAddress;
    /**
     * 所属公司
     */
    @ApiModelProperty("所属公司")
    private String ownedCompany;
    /**
     * 发票抬头
     */
    @ApiModelProperty("发票抬头")
    private String invTitle;
    /**
     * 银行账户
     */
    @ApiModelProperty("银行账户")
    private String bankAccount;
    /**
     * 发票代码
     */
    @ApiModelProperty("发票代码")
    private String invNo;
    /**
     * 税号
     */
    @ApiModelProperty("税号")
    private String taxNo;
    /**
     * 企业电话
     */
    @ApiModelProperty("企业电话")
    private String companyTel;
    /**
     * 发票编码
     */
    @ApiModelProperty("发票编码")
    private String invCode;
    /**
     * 开户银行
     */
    @ApiModelProperty("开户银行")
    private String bank;
    /**
     * 发票类型
     */
    @ApiModelProperty("发票类型")
    private String invType;
    /**
     * 客户Id
     */
    @ApiModelProperty("客户Id")
    private Long custAccountId;

    //zhao.zhi.hao 2021.09.23
    /**
     * 订单id集合
     */
    @ApiModelProperty("订单编号集合")
    private List<Long> orderIds;

    /**
     * 订单编号集合
     */
    @ApiModelProperty("订单编号集合")
    private List<String> orderNos;

    /**
     * 发票单流水号
     */
    @ApiModelProperty("发票单流水号")
    private List<String> invSerialNums;

}
