package com.elitesland.sale.api.vo.resp.shop.app;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021/08/25
 */
@Data
@ApiModel(description = "商品优惠")
public class BipItemPromotionAppRespVO implements Serializable {
    private static final long serialVersionUID = 8571228478852846307L;

    @ApiModelProperty(value = "活动类型，满减、满赠等", position = 1)
    private String type;

    @ApiModelProperty(value = "活动类型，满减、满赠等", position = 2)
    private String typeName;

    @ApiModelProperty(value = "活动列表", position = 3)
    private List<PromotionDetail> detailList;

    @Data
    @ApiModel(value = "BipItemDetailAppRespVO_PromotionDetail", description = "商品优惠活动")
    public static class PromotionDetail implements Serializable {
        private static final long serialVersionUID = 7635924161371117049L;

        @ApiModelProperty(value = "活动ID", position = 1)
        private Long id;

        @ApiModelProperty(value = "活动描述", position = 2)
        private String desc;
    }
}
