package com.elitesland.sale.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.sale.Application;
import com.elitesland.sale.dto.CrmCustDTO;
import com.elitesland.sale.dto.CrmCustSimpleDTO;
import com.elitesland.sale.dto.CrmCustSubDTO;
import com.elitesland.sale.dto.CrmCustSubRpcVO;
import com.elitesland.sale.dto.param.CrmCustSubRpcParam;
import feign.Param;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 分部客户中心服务接口.
 *
 * @author Kaiser（wang shao）
 * @date 2021-05-14
 */
@FeignClient(name = Application.NAME, path = CrmCustSubRpcService.URI)
public interface CrmCustSubRpcService {
    String URI = Application.URI_PREFIX + "/custSub";

    /**
     * 搜索客户信息
     *
     * @param param
     * @return 客户信息
     */
    @PostMapping("/query")
    ApiResult<List<CrmCustSubDTO>> query(@RequestBody CrmCustSubRpcParam param);


    /**
     * 根据客户ID查询客户信息
     *
     * @param ids 客户ID
     * @return 客户信息
     */
    @PostMapping("/crmCustRpc/listCustById")
    ApiResult<List<CrmCustSubRpcVO>> listCustById(@RequestBody List<Long> ids);

}
