package com.elitesland.sale.api.vo.resp.zone;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
@ApiModel(description = "专区设置")
public class ZoneSettingVO implements Serializable {

	private static final long serialVersionUID = -2000470641101961084L;
	@ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("专区编码")
    private String zoneCode;


    @ApiModelProperty("专区名称")
    private String zoneName;

    @ApiModelProperty("排序")
    private Integer sort;

    @ApiModelProperty("所属公司")
    private Long ouId;

    @ApiModelProperty("所属公司名称")
    private String ouName;

    @ApiModelProperty(value = "状态 [UDC]SAL:ZONE_STATUS")
    @SysCode(sys = "yst-sale", mod = "ZONE_STATUS")
    private String status;
    private String statusName;

    @ApiModelProperty("secOuId")
    private Long secOuId;

    @ApiModelProperty(value = "详情")
    private List<ZoneSettingDVO> list;


}
