package com.elitesland.sale.api.service;

import com.alibaba.fastjson.JSONObject;
import com.elitesland.sale.api.dto.CustSaleContractDTO;
import com.elitesland.sale.api.vo.param.pro.SalContractApprParam;
import com.elitesland.sale.api.vo.param.pro.SalContractPagingParam;
import com.elitesland.sale.api.vo.param.pro.SalContractQueryParam;
import com.elitesland.sale.api.vo.param.pro.SalContractSaveParam;
import com.elitesland.sale.api.vo.resp.pro.SalContractDetailRespVO;
import com.elitesland.sale.api.vo.resp.pro.SalContractExportVO;
import com.elitesland.sale.api.vo.resp.pro.SalContractPageRespVO;
import com.elitesland.sale.api.vo.resp.pro.SalContractSimpleRespVO;
import com.elitesland.sale.api.vo.resp.sal.SalCommissionRuleVO;
import com.elitesland.sale.api.vo.save.SalContractImportSaveVO;
import com.elitesland.sale.api.vo.save.SalContractItemImportSaveVO;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;

/**
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/6/8 9:09 上午
 */
public interface SalContractService {

    /**
     * 根据查询条件分页查询项目合同信息列表
     * @param pageParam 查询条件
     * @return
     */
    PagingVO<SalContractPageRespVO> query(SalContractPagingParam pageParam);

    /**
     * 保存或提交销售合同信息
     * @param param 参数
     * @return
     */
    JSONObject saveOrSubmit(SalContractSaveParam param, String operate);

    /**
     *
     * @param custCode
     * @return
     */
    List<CustSaleContractDTO> findSignInfo(String custCode);
}
