package com.elitesland.sale.api.vo.param.sal;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author JinXK
 * @date 2021/6/2 14:16
 */
@Data
@ApiModel(description = "销售开票申请保存或提交入参")
public class SalInvApplySaveParam implements Serializable {
    private static final long serialVersionUID = 2384491124236160538L;

    @ApiModelProperty(value = "主键ID")
    private Long id;

    @ApiModelProperty(value = "租户ID")
    private Long tenantId;

    @ApiModelProperty(value = "BUID")
    private Long buId;

    @ApiModelProperty(value = "BUNAME")
    private String buName;

    @ApiModelProperty(value = "单据编号")
    private String docNo;

    @ApiModelProperty(value = "单据类型 [UDC]SAL:INV_APPLY_TYPE")
    private String docType;

    @ApiModelProperty(value = "单据状态 [UDC]SAL:BILL_STATUS")
    private String docStatus;

    @ApiModelProperty(value = "申请人员工ID")
    private Long applyEmpId;

    @ApiModelProperty(value = "申请人姓名")
    private String applyName;

    @ApiModelProperty(value = "申请人电话")
    private String applyPhone;

    @ApiModelProperty(value = "申请日期")
    private LocalDateTime applyDate;

    @ApiModelProperty(value = "申请描述")
    private String applyDesc;

    @ApiModelProperty(value = "审批状态 [UDC]COM:APPR_STATUS")
    private String apprStatus;

    @ApiModelProperty(value = "审批时间")
    private LocalDateTime apprTime;

    @ApiModelProperty(value = "审批人ID")
    private Long apprUserId;

    @ApiModelProperty(value = "审批意见")
    private String apprComment;

    @ApiModelProperty(value = "客户ID")
    private Long custId;

    @ApiModelProperty(value = "客户编号")
    private String custCode;

    @ApiModelProperty(value = "客户名称")
    private String custName;

    @ApiModelProperty(value = "合同ID")
    private Long contractId;

    @ApiModelProperty(value = "合同编号")
    private String contractCode;

    @ApiModelProperty(value = "合同名称")
    private String contractName;

    @ApiModelProperty(value = "开票金额")
    private BigDecimal invAmt;

    @ApiModelProperty(value = "开票税额")
    private BigDecimal taxAmt;

    @ApiModelProperty(value = "预计到款日期")
    private LocalDateTime planReceiptDate;

    @ApiModelProperty(value = "税率编号")
    private String taxRateNo;

    @ApiModelProperty(value = "税率")
    private BigDecimal taxRate;

    @ApiModelProperty(value = "购方名称")
    private String invTitle;

    @ApiModelProperty(value = "税号")
    private String taxerNo;

    @ApiModelProperty(value = "发票类型 [UDC]COM:INV_TYPE")
    private String invType;

    @ApiModelProperty(value = "开票电话")
    private String invTel;

    @ApiModelProperty(value = "开票地址")
    private String invAddress;

    @ApiModelProperty(value = "开票联系人")
    private String invPicName;

    @ApiModelProperty(value = "开票联系人电话")
    private String invPicPhone;

    @ApiModelProperty(value = "开票银行名称")
    private String invBankName;

    @ApiModelProperty(value = "开票银行支行")
    private String invBankBranch;

    @ApiModelProperty(value = "开票银行账号")
    private String invBankAcc;

    @ApiModelProperty(value = "开票收件地址")
    private String invRecvAddress;

    @ApiModelProperty(value = "销售公司ID")
    private Long ouId;

    @ApiModelProperty(value = "销售公司编号")
    private String ouCode;

    @ApiModelProperty(value = "销售公司名称")
    private String ouName;

    @ApiModelProperty(value = "销售区域 [UDC]SAL:SAL_REGION")
    private String saleRegion;

    @ApiModelProperty(value = "下单渠道 [UDC]SAL:SO_SOURCE")
    private String soSource;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "创建人ID")
    private Long createUserId;

    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "最后编辑人ID")
    private Long modifyUserId;

    @ApiModelProperty(value = "最后编辑时间")
    private LocalDateTime modifyTime;

    @ApiModelProperty(value = "销售开票申请明细列表")
    private List<SalInvApplydSaveParam> details;

    @ApiModelProperty(value = "对账单或销售单--对账单(SOA) 销售单(SO)")
    private String soaOrSo;

    @ApiModelProperty(value = "推送方式 [UDC]FIN:PUSH_METHOD")
    private String pushMethod;

    @ApiModelProperty(value = "手机号")
    private String phone;

    @ApiModelProperty(value = "邮箱")
    private String email;

    @ApiModelProperty(value = "蓝票/红票 [UDC]FIN:OPEN_TYPE")
    private String openType;

    @ApiModelProperty(value = "是否红冲")
    private String offFlag;

    @ApiModelProperty(value = "发票系统流水号")
    private String invFlow;

    @ApiModelProperty(value = "相关单据ID")
    private Long relateDocId;

    @ApiModelProperty(value = "相关单据编号 原始单号")
    private String relateDocNo;

    @ApiModelProperty(value = "原单发票号码")
    private String offInvNo;

    @ApiModelProperty(value = "原单发票代码")
    private String offInvCode;

    @ApiModelProperty(value = "原单流水号")
    private String offFlowNo;
}
