package com.elitesland.sale.api.vo.param.shop;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 收货地址(BipAddress)实体类
 *
 * @author makejava
 * @since 2021-09-01 14:43:59
 */

@Data
@ApiModel(value = "bip_address", description = "收货地址")
public class BipAddressUpdateParam implements Serializable {
    private static final long serialVersionUID = 280133076102810276L;
    @ApiModelProperty("ID")
    @JsonSerialize(
            using = ToStringSerializer.class
    )
    private Long id;
    @ApiModelProperty("地址类型(指送货地址，开票地址等):[UDC]ORG:")
    @SysCode(
            sys = "ORG",
            mod = "ADDRESS_TYPE"
    )
    private String addressType;
    @ApiModelProperty("地址类型(指送货地址，开票地址等)名称")
    private String addressTypeName;
    @ApiModelProperty("是否默认：1是，0否")
    private Boolean defaultFlag;
    @ApiModelProperty("联系人姓名")
    private String contPerson;
    @ApiModelProperty("手机号码")
    private String mobile;
    @ApiModelProperty("电话")
    private String tel;
    @ApiModelProperty("传真")
    private String fax;
    @ApiModelProperty("电邮")
    private String email;
    @ApiModelProperty("邮政编码")
    private String zipCode;
    @ApiModelProperty("国家")
    private String country;
    @ApiModelProperty("省份(编号/ID)")
    private String province;
    @ApiModelProperty("省份名称")
    private String provinceName;
    @ApiModelProperty("城市(编号/ID)")
    private String city;
    @ApiModelProperty("城市名称")
    private String cityName;
    @ApiModelProperty("区县(编号/ID)")
    private String county;
    @ApiModelProperty("区县名称")
    private String countyName;
    @ApiModelProperty("街道/乡镇(文本)")
    private String street;
    @ApiModelProperty("详细地址")
    private String detailAddr;

}
