package com.elitesland.sale.api.vo.param.special;


import com.elitesland.sale.api.vo.resp.shop.FirstSpecialItemVO;
import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 *
 */
@Data
@ApiModel(description = "首单特惠保存")
public class FirstSpecialItemSaveParam {

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("商品ID")
    private Long itemId;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("状态")
    @SysCode(sys = "yst-sale", mod = "SPECIAL_STATUS")
    private String status;
    private String statusName;

    @ApiModelProperty("优先级")
    private Integer sort;

    @ApiModelProperty("明细")
    List<FirstSpecialItemVO> list;


}
