package com.elitesland.sale.api.vo.resp.itm;

import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

/**
 * 上架spu在es里的存储结构
 * @author : 常浩波
 * @date 2023/03/08
 */
@Data
public class ItmItemSpuDetailsEsVO implements Serializable {
    private static final long serialVersionUID = -954270163717207813L;

    // ***************************************************************************
    // ********************************* 基本信息 *********************************

    /**
     * 销售渠道
     */
    private String channelType;
    /**
     * 发货基地
     */
    private Long desId;
    /**
     * spuId
     */
    private Long spuId;

    /**
     * SPU编号
     */
    private String spuCode;

    /**
     * SPU名称
     */
    private String spuName;

    /**
     * 品类编号
     */
    private String itemCateCode;

    /**
     * 整车配件 [UDC]ITM:ITEM_TYPE2
     */
    private String itemType2;
    private String itemType2Name;

    /**
     * 整车类型
     */
    private String itemType3;

    /**
     * 系列
     */
    private String itemGroup;

    /**
     * 产地/原产国，udc[yst-supp:ORIGIN]
     */
    private String origin;
    private String originName;

    /**
     * 排序配置
     * sortConfig:
     * 	all: num
     * 	specialAreas:
     * 		hn: num
     * 		xj: num
     * 	specialCusts:
     * 		custCode1: num
     * 		custCode2: num
     *
     * num * 10000 * 10000
     * 		   num * 10000
     * 				   num
     * 				     0
     */
    private Map<String, Object> sortConfig;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 详细描述
     */
    private String itemDescribe;

    /**
     * 商品图片
     */
    private List<ItmItemAttachmentEsVO> spuImages;

    /**
     * 商品视频
     */
    private List<ItmItemAttachmentEsVO> spuVideos;

    /**
     * 商品规格 SKU 信息列表
     */
    private List<ItmItemSkuEsVO> lmItemSkuVos;
}
