package com.elitesland.sale.api.vo.resp.logistics;


import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

import java.time.LocalDateTime;

@Data
@ApiModel(description = "运费模板列表")
public class LogisticsTemplateVO implements Serializable {


	private static final long serialVersionUID = 3336317604573027162L;
	@ApiModelProperty("id")
    private Long id;


    @ApiModelProperty("物流模板编码")
    private String logisticsCode;

    @ApiModelProperty("物流模板名称")
    private String logisticsName;

    @ApiModelProperty("运费模板描述")
    private String logisticDesc;


    @ApiModelProperty(value = "状态 [UDC]SAL:LOGISTICS_TEMPLATE_STATUS")
    @SysCode(sys = "yst-sale", mod = "LOGISTICS_TEMPLATE_STATUS")
    private String status;
    private String statusName;

    @ApiModelProperty("所属公司")
    private Long ouId;

    @ApiModelProperty("所属公司名称")
    private String ouName;

    @ApiModelProperty("记录创建者")
    private String creator;

    @ApiModelProperty("记录创建者ID")
    private Long createUserId;

    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTime;

//    @ApiModelProperty("发货地")
//    private String shipAddress;

    @ApiModelProperty("发货省")
    private String provinceName;

    @ApiModelProperty("发货省代码")
    private String provinceCode;

    @ApiModelProperty("发货市")
    private String cityName;

    @ApiModelProperty("发货市代码")
    private String cityCode;

    @ApiModelProperty("发货区")
    private String countyName;

    @ApiModelProperty("发货区代码")
    private String countyCode;

    @ApiModelProperty("运费模板明细")
    List<LogisticsTemplateDVO> list;



}
