package com.elitesland.sale.api.vo.save;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
@ApiModel(description = "允发期保存")
public class AllowShipRuleSaveVO implements Serializable {
    private static final long serialVersionUID = 1294865053152434493L;

    @ApiModelProperty(value = "id")
    private Long id;

    @ApiModelProperty(value = "名称")
    private String name;


    @ApiModelProperty(value = "编码")
    private String code;


    @ApiModelProperty(value = "状态 UDC:yst-sale:ALLOW_SHIP_STATUS (ACTIVE:启用,CLOSED:禁用)")
    private String status;

    @ApiModelProperty(value = "算法 UDC:yst-sale:ALLOW_SHIP_ALGORITHM (RESIDUE_DAY:剩余效期天数 ,RESIDUE_RATIO:剩余有效期比例)")
    private String algorithm;


    @ApiModelProperty(value = "剩余允发期比例")
    private String residueAllowShipRatio;


    @ApiModelProperty(value = "剩余允发期小数")
    private BigDecimal residueAllowShipDecimal;


    @ApiModelProperty(value = "剩余允发期天数")
    private Integer residueAllowShipDay;


    @ApiModelProperty(value = "描述")
    private String allowDescribe;


}
