package com.elitesland.sale.api.vo.resp.taskinfo;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.sale.api.vo.resp.BaseModelVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;


/**
 * @author : http://www.chiner.pre
 * @date : 2023-4-12
 * @desc : 执行记录
 */
@Data
@ApiModel(description = "执行记录")
public class ExecutRecordRespVO extends BaseModelVO {

    @ApiModelProperty("执行记录编码")
    private String code;

    @ApiModelProperty("任务编码")
    private String taskCode;

    @ApiModelProperty("任务id")
    private Long taskId;

    @ApiModelProperty("任务明细id")
    private Long taskDtlId;

    @ApiModelProperty("任务名称")
    private String taskName;

    @ApiModelProperty("任务类型")
    @SysCode(sys = "yst-sale",mod = "SALESMAN_TASK_TYPE")
    private String taskType;
    private String taskTypeName;

    @ApiModelProperty("发布人")
    private String publishUser;

    @ApiModelProperty("发布人id")
    private Long publishUserId;

    @ApiModelProperty("发布人code")
    private String publishUserCode;

    @ApiModelProperty("状态")
    @SysCode(sys = "yst-sale",mod = "EXECT_RECORD_STATUS")
    private String state;
    private String stateName;

    @ApiModelProperty("执行人")
    private String executUser;

    @ApiModelProperty("执行人id")
    private Long executUserId;

    @ApiModelProperty("执行人code")
    private String executUserCode;

    @ApiModelProperty("业务类型")
    private String businessType;

    @ApiModelProperty("业务")
    private Long businessId;

    @ApiModelProperty("业务编码")
    private String businessCode;

    @ApiModelProperty("业务名称")
    private String businessName;

    @ApiModelProperty("开始时间")
    private LocalDateTime startTime;

    @ApiModelProperty("结束时间")
    private LocalDateTime endTime;

    @ApiModelProperty("审核内容")
    private String auditDesc;

    @ApiModelProperty("强制签到")
    private String forceSignFlag;

    @ApiModelProperty("执行模板code")
    private String executTemplateCode;

    @ApiModelProperty("执行记录明细集合")
    private List<ExecutRecordDtlRespVO> executRecordDtlRespVOS;

    @ApiModelProperty("文件附件表")
    private List<FileInfoRespVO> fileInfoRespVOS;
    @ApiModelProperty("执行记录模板附件表")
    private List<ExectRecordDtlTempRespVO> recordDtlTempRespVOS;



}