package com.elitesland.sale.api.dto;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 商品信息.
 *
 * @author Kaiser（wang shao）
 * @date 2021/09/02
 */
@Data
public class BipItemDTO implements Serializable {
    private static final long serialVersionUID = -304980053954550509L;

    /**
     * 商品ID
     */
    private Long id;

    /**
     * 上架编码
     */
    private String shelfCode;

    /**
     * 商品中心的商品ID
     */
    private Long itemId;

    /**
     * 商品中心的商品编码
     */
    private String itemCode;

    /**
     * 商品名称
     */
    private String itemName;

    /**
     * 所属公司
     */
    private Long ouId;

    /**
     * 所属组织
     */
    private Long buId;

    /**
     * 商品标题
     */
    private String title;

    /**
     * 是否包邮
     */
    private Boolean fareFree;

    /**
     * 运费模板ID
     * 不包邮时有运费模板
     */
    private Long fareTmplId;

    /**
     * 主图的文件编码
     */
    private String mainPicFileCode;

    /**
     * 主图的访问链接
     */
    private String mainPicUrl;

    /**
     * 是否已上架
     */
    private Boolean onShelf;

    /**
     * 基础价
     */
    private BigDecimal price;

    /**
     * SKU列表
     */
    private List<BipItemSkuDTO> skuList;
}
