package com.elitesland.sale.dto;

import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModelVo;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.sale.api.vo.resp.crm.*;
import com.elitesland.support.provider.org.dto.OrgBusinessScopeRpcDTO;
import com.elitesland.support.provider.org.dto.OrgCodeNameVO;
import com.elitesland.support.provider.org.dto.OrgQualifyReviewRpcDTO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * .
 *
 * @author Evin.dong
 * @date 2021-05-19
 */
@Data
@ApiModel(description = "客户表新增编辑入参")
public class CrmCustSubRpcVO extends CustomFieldBaseModelVo implements Serializable {

    private static final long serialVersionUID = -6580640909133208873L;

//    @ApiModelProperty(value = "客户id")
//    @JsonSerialize(using = ToStringSerializer.class)
//    private Long id;


    @ApiModelProperty("主键id")
    private Long id;


    @ApiModelProperty("销售模式")
    private String saleMode;

    @ApiModelProperty("法人代表（基础信息）") // 第一次出现：补充"基础信息"标识
    private String repr;

    @ApiModelProperty("法人联系方式（基础信息）") // 第一次出现：补充"基础信息"标识
    private String reprCertMobile;

    @ApiModelProperty(value = "客户编码（主编码）") // 第一次出现：补充"主编码"标识
    private String custCode;

    @ApiModelProperty(value = "客户编码2（备用编码）") // 第一次出现：补充"备用编码"标识
    private String custCode2;

    @ApiModelProperty(value = "外部系统编码")
    private String outerCode;

    @ApiModelProperty(value = "登录账号")
    private String userName;


    @ApiModelProperty(value = "地址簿ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long addrId;

    @ApiModelProperty(value = "地址号")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long addrNo;

    @ApiModelProperty(value = "税务登记号")
    private String taxRegNo;

    @ApiModelProperty(value = "工商登记号")
    private String icRegisterNo;

    @ApiModelProperty(value = "客户名称（全称）") // 第一次出现：补充"全称"标识
    private String custName;

    @ApiModelProperty(value = "客户简称")
    private String custAbbr;

    @ApiModelProperty(value = "英文名称")
    private String custName2;

    @ApiModelProperty(value = "公司id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty(value = "公司编号", required = true)
    private String ouCode;

    @ApiModelProperty(value = "公司名称")
    private String ouName;

    @ApiModelProperty(value = "销售组织ID", required = true)
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;

    @ApiModelProperty(value = "销售组织编号")
    private String buCode;

    @ApiModelProperty(value = "销售组织名称")
    private String buName;

    @ApiModelProperty(value = "区域", required = true)
    private String region;
    private String regionName;

    @ApiModelProperty(value = "业务员id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long agentEmpId;

    @ApiModelProperty(value = "业务员code")
    private String agentEmpCode;
    @ApiModelProperty(value = "业务员名称")
    private String agentEmpName;

    @ApiModelProperty(value = "证照类型") // 第一次出现：补充"一级分类"标识
    private String custType;

    @ApiModelProperty(value = "证照类型") // 第一次出现：补充"一级分类"标识
    private List<OrgCodeNameVO> custTypeList;

    @ApiModelProperty(value = "客户状态")
    private String custStatus;
    private String custStatusName;

    @ApiModelProperty(value = "客户等级")
    private String custLevel;
    private String custLevelName;

    @ApiModelProperty(value = "客户行业（主行业）") // 第一次出现：补充"主行业"标识
    private String custIndustry;
    private String custIndustryName;

    @ApiModelProperty(value = "客户来源（主来源）") // 第一次出现：补充"主来源"标识
    private String custSource;
    private String custSourceName;

    @ApiModelProperty(value = "客户规模")
    private String compScale;
    private String compScaleName;

    @ApiModelProperty(value = "客户年营业额")
    private String compTurnover;

    @ApiModelProperty(value = "客户归类")
    private String custType2;

    @ApiModelProperty(value = "发票类型")
    private String invType;

    @ApiModelProperty(value = "开票抬头")
    private String invTitle;

    @ApiModelProperty(value = "开票地址")
    private String invAddress;

    @ApiModelProperty(value = "开票电话")
    private String invTel;

    @ApiModelProperty(value = "开户银行")
    private String invBankName;

    @ApiModelProperty(value = "银行账户")
    private String invBankAcc;

    @ApiModelProperty(value = "联系人（开票联系人）") // 第一次出现：补充"开票联系人"标识
    private String invPicName;

    @ApiModelProperty(value = "联系人电话（开票联系人）") // 第一次出现：补充"开票联系人"标识
    private String invPicPhone;

    @ApiModelProperty(value = "付款条款 yst-supp:PAYMENT_TERM")
    private String paymentTerm;
    private String paymentTermName;

    @ApiModelProperty(value = "默认税率")
    private BigDecimal taxRate;

    @ApiModelProperty(value = "客户地址列表数据")
    private List<CrmCustAddrRespVO> addrList;
/*
    @ApiModelProperty(value = "证照信息列表数据")
    private List<CrmCustQualifySaveVO> qualifyList;*/

    @ApiModelProperty(value = "银行信息")
    private List<OrgAddrBankAccRespVO> orgAddrBankAccList;

    @ApiModelProperty("联系人电话（业务联系人）") // 第一次出现：补充"业务联系人"标识
    private String contactPhone;

    @ApiModelProperty("联系人姓名（业务联系人）") // 第一次出现：补充"业务联系人"标识
    private String contactName;


    private CustAccountVO custAccountVO;


    @ApiModelProperty("统一信用代码（主体资质）") // 第一次出现：补充"主体资质"标识
    private String certNo;


    @ApiModelProperty(value = "纳税人类型")
    private String taxpayerType;

    @ApiModelProperty(value = "客户分类（二级分类）") // 第一次出现：补充"二级分类"标识
    private String custGroup;
    private String custGroupName;

    @ApiModelProperty(value = "结算币种")
    private String custCurr;

    @ApiModelProperty(value = "税号")
    private String taxerNo;


    @ApiModelProperty(value = "同步状态")
    private String intfStatus;


    @ApiModelProperty("默认允发期code")
    private String allowShipRuleCode;

    @ApiModelProperty("允发最大批次数量")
    private String allowBatchMax;
/*
    @ApiModelProperty("交货清单")
    List<DeliveryListSaveVO> deliveryList;*/

    @ApiModelProperty(value = "交货清单")
    private List<DeliveryListRespVO> deliveryList;
    @ApiModelProperty("默认配送方式 yst-order:SO_DELIVER_METHOD")
    private String deliverMethod;
    private String deliverMethodName;

    @ApiModelProperty("渠道 yst-supp:CUST_CHANNEL")
    private String saleChannel;
    private String saleChannelName;
    @ApiModelProperty("渠道数组")
    private List<OrgCodeNameVO> saleChannelList;

    @ApiModelProperty("承运信息")
    private String carrier;

    @ApiModelProperty("所属公司")
    private List<CustBelongOuVO> belongOus;

    @ApiModelProperty(value = "税率编号")
    private String taxRateNo;

    @ApiModelProperty(value = "内外部客户")
    private String inOutCust;
    private String inOutCustName;


    @ApiModelProperty(value = "客户创建时，客户创建入口来源（当前内部使用，不建udc），00:门店创建时字段创建客户")
    private String createFrom;

    @ApiModelProperty("资质文审信息")
    private List<OrgQualifyReviewRpcDTO> orgQualifyReviewVOList;
    @ApiModelProperty("经营范围")
    private List<OrgBusinessScopeRpcDTO> orgBusinessScopeVOList;


    @ApiModelProperty("单据编号")
    private String docNo;

    @ApiModelProperty("单据类型 [UDC]SALE:DOC_TYPE_CUST_APPLY_SUB")
    @SysCode(sys = "yst-sale", mod = "DOC_TYPE_CUST_APPLY_SUB")
    private String docType;

    private String docTypeName;

    @ApiModelProperty("审批时间")
    private LocalDateTime apprTime;

    @ApiModelProperty("审批人ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long apprUserId;

    @ApiModelProperty("审批人")
    private String apprUserName;

    @ApiModelProperty("申请人员工ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long applyEmpId;

    @ApiModelProperty("申请人员工名称")
    private String applyEmpName;

    @ApiModelProperty("申请日期")
    private LocalDateTime applyDate;

    @ApiModelProperty("单据状态 [UDC]purc:SUPP_APPLY_STATUS")
    @SysCode(sys = "yst-purc", mod = "SUPP_APPLY_STATUS")
    private String docStatus;

    private String docStatusName;

    @ApiModelProperty("备注")
    private String remark;


    @ApiModelProperty(value = "是否股东 UDC:PUR:TRUE_OR_FALSE")
    private String shareholderFlag;
    private String shareholderFlagName;

    @ApiModelProperty(value = "助记码")
    private String mnemonicCode;

    @ApiModelProperty(value = "医药客户 UDC:PUR:TRUE_OR_FALSE")
    private String medicalCustFlag;
    private String medicalCustFlagName;

    @ApiModelProperty("企业地址（注册地址）") // 第一次出现：补充"注册地址"标识
    private String registerAddress;


    @ApiModelProperty("企业类别 [UDC]PUR:COMP_PROP")
    @SysCode(sys = "yst-purc", mod = "COMP_PROP")
    private String compProp;
    private String compPropName;
    @ApiModelProperty("线上/线下 [UDC]yst-supp:CHANNEL_TYPE")
    @SysCode(sys = "yst-supp", mod = "CHANNEL_TYPE")
    private String channelType;
    private String channelTypeName;

    @ApiModelProperty("省级行政编码")
    private String provinceCode;
    @ApiModelProperty("省级行政名称")
    private String provinceName;
    @ApiModelProperty("经销商类型 [UDC]yst-sale:DEALER_TYPE")
    private String dealerType;
    @ApiModelProperty("是否年检 0：否 1：是")
    //@Column(name = "annual_check", columnDefinition = "boolean comment '是否年检 0：否 1：是'")
    private String annualCheck;

    @ApiModelProperty("质量人员编码")
    private String qualityEmpCode;
    @ApiModelProperty("质量人员名称")
    private String qualityEmpName;
    @ApiModelProperty("质量电话")
    private String qualityTel;
    @ApiModelProperty(value = "效期控制 UDC:PUR:TRUE_OR_FALSE")
    private String guaranteeFlag;

    @ApiModelProperty("预警天数")
    private Integer warnDays;

    @ApiModelProperty(value = "是否预约收获 UDC:PUR:TRUE_OR_FALSE")
    private String recvFlag;
    @ApiModelProperty(value = "最低预约收获")
    private Integer minRecv;
    @ApiModelProperty(value = "账期管控 UDC:SALE:ARDAYS_CONTROL")
    @SysCode(sys = "yst-sale", mod = "ARDAYS_CONTROL")
    private String ardaysControl;
    private String ardaysControlName;
}
