package com.elitesland.sale.api.vo.resp.shop;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.sale.api.AmtBigDecimalJsonSerialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 买赠折扣信息 VO
 * </p>
 *
 * @author ssy
 * @since 2021/8/24
 */
@ApiModel(description = "买赠折扣信息")
@Data
public class MktDiscountGiftVO implements Serializable {

    private static final long serialVersionUID = 5899415963010002217L;
    /**
     * 折扣主表
     */
    @ApiModelProperty(value = "折扣赠主表ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long mktDiscountGiftId;

    @ApiModelProperty(value = "折扣编码")
    private String code;

    @ApiModelProperty(value = "折扣名称")
    private String name;

    @ApiModelProperty(value = "折扣生效时间")
    private LocalDateTime validStime;

    @ApiModelProperty(value = "折扣失效时间")
    private LocalDateTime validEtime;

    @ApiModelProperty(value = "客户等级")
    @SysCode(sys = "yst-sale", mod = "CUST_LEVEL")
    private String customLevel;
    private String customLevelName;

    @ApiModelProperty(value = "销售公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty(value = "销售公司编码")
    private String ouCode;

    @ApiModelProperty(value = "销售公司名称")
    private String ouName;

    @ApiModelProperty(value = "销售组织ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;

    @ApiModelProperty(value = "销售组织编码")
    private String buCode;

    @ApiModelProperty(value = "销售组织名称")
    private String buName;

    @ApiModelProperty(value = "'促销条件:0 件数 1 金额")
    @SysCode(sys = "yst-sale", mod = "DISCOUNT_OFFSET_TYPE")
    private String type;
    private String typeName;

    @ApiModelProperty(value = "促销状态")
    @SysCode(sys = "yst-sale", mod = "DISCOUNT_OFFSET_STATUS")
    private String status;
    private String statusName;

    /**
     * 折扣明细
     */
    @ApiModelProperty(value = "折扣赠明细表ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long mktDiscountGiftDId;

    @ApiModelProperty(value = "商品ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty(value = "商品编码")
    private String itemCode;

    @ApiModelProperty(value = "商品名称")
    private String itemName;

    @ApiModelProperty(value = "商品规格")
    private String itemAttr;

    @ApiModelProperty(value = "计量单位")
    private String uom;
    private String uomName;

    @ApiModelProperty(value = "满赠达标金额")
    @JsonSerialize(using = AmtBigDecimalJsonSerialize.class)
    private BigDecimal limitAmt;

    @ApiModelProperty(value = "满赠达标数量")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long limitNum;

    /**
     * 赠品信息
     */
    @ApiModelProperty(value = "赠品信息(集合)")
    List<MktGiftRespVO> giftDetails;

    @ApiModelProperty("折扣编码")
    private String discountGiftCode;
}
