package com.elitesland.sale.api.vo.resp.itm;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/11/4 19:30
 */
@Data
@ApiModel("经营目录商品SKU分页DTO")
public class ItmItemBusionessPagingDTO implements Serializable {

    private static final long serialVersionUID = 4122620230454194826L;

    @JsonSerialize(
            using = ToStringSerializer.class
    )
    @ApiModelProperty("主键 Id")
    private Long id;

    @JsonSerialize(
            using = ToStringSerializer.class
    )
    @ApiModelProperty("商品SKU Id")
    private Long itemId;
    @JsonSerialize(
            using = ToStringSerializer.class
    )
    @ApiModelProperty("商品经营目录 Id")
    private Long businessId;
    @ApiModelProperty("商品SKU编号")
    private String itemCode;
    @ApiModelProperty("商品SKU名称")
    private String itemName;
    @ApiModelProperty("商品简称")
    private String itemAbbr;
    @ApiModelProperty("外部编号")
    private String outerCode;
    @ApiModelProperty("条码")
    private String barCode;
    @ApiModelProperty("品类(SPU)编号")
    private String itemCateCode;
    @ApiModelProperty("品类(SPU)全路径名称")
    private List<String> itemCatePathName;
    @ApiModelProperty("商品类型 [UDC]ITM:ITEM_TYPE")
    @SysCode(
            sys = "ITM",
            mod = "ITEM_TYPE"
    )
    private String itemType;
    private String itemTypeName;
    @ApiModelProperty("商品类型 [UDC]ITM:ITEM_TYPE2")
    @SysCode(
            sys = "ITM",
            mod = "ITEM_TYPE2"
    )
    private String itemType2;
    private String itemType2Name;
    @ApiModelProperty("商品类型 [UDC]ITM:ITEM_STATUS")
    @SysCode(
            sys = "ITM",
            mod = "ITEM_STATUS"
    )
    private String itemStatus;
    private String itemStatusName;
    @ApiModelProperty("规格")
    private String spec;
    @ApiModelProperty("品牌")
    private String brand;
    @ApiModelProperty("品牌名称")
    private String brandName;
    @ApiModelProperty("包装规格")
    String packageSpec;
    @ApiModelProperty("主计量单位")
    @SysCode(
            sys = "COM",
            mod = "UOM"
    )
    private String uom;
    private String uomName;
    @ApiModelProperty("定价计量单位")
    @SysCode(
            sys = "COM",
            mod = "UOM"
    )
    private String pricingUom;
    private String pricingUomName;
    @ApiModelProperty("发运计量单位")
    @SysCode(
            sys = "COM",
            mod = "UOM"
    )
    private String shipUom;
    private String shipUomName;
    @ApiModelProperty("默认销售单位 [UDC]COM:UOM")
    @SysCode(
            sys = "COM",
            mod = "UOM"
    )
    private String saleUom;
    private String saleUomName;
    @ApiModelProperty("默认采购单位")
    @SysCode(
            sys = "COM",
            mod = "UOM"
    )
    private String purcUom;
    private String purcUomName;
    @ApiModelProperty("毛重")
    private BigDecimal grossWeight;
    @ApiModelProperty("净重")
    private BigDecimal netWeight;
    @ApiModelProperty("重量单位 [UDC]COM:WEIGHT_UNIT")
    @SysCode(
            sys = "COM",
            mod = "WEIGHT_UNIT"
    )
    private String weightUnit;
    private String weightUnitName;
    @ApiModelProperty("体积")
    private BigDecimal volume;
    @ApiModelProperty("体积单位 [UDC]COM:VOLUME_UNIT")
    @SysCode(
            sys = "COM",
            mod = "VOLUME_UNIT"
    )
    private String volumeUnit;
    private String volumeUnitName;
    @ApiModelProperty("配货类型 [UDC]ITM:ALLOC_TYPE")
    @SysCode(
            sys = "ITM",
            mod = "ALLOC_TYPE"
    )
    private String allocType;
    private String allocTypeName;
    @ApiModelProperty("供应商ID")
    @JsonSerialize(
            using = ToStringSerializer.class
    )
    private Long suppId;
    @ApiModelProperty("供应商编号")
    private String suppCode;
    @ApiModelProperty("供应商名称")
    private String suppName;
    @ApiModelProperty("税码(进项)")
    private String taxCode;
    @ApiModelProperty("税率(进项)，小于1的小数，保留8位，四舍五入")
    private BigDecimal taxRate;
    @ApiModelProperty("税率描述(进项)")
    private String taxRateDesc;
    @ApiModelProperty("税码2(销项)")
    private String taxCode2;
    @ApiModelProperty("税率2(销项)")
    private BigDecimal taxRate2;
    @ApiModelProperty("税率2描述(销项)")
    private String taxRate2Desc;
    @ApiModelProperty("关税税率")
    private BigDecimal taxRateTariff;
    @ApiModelProperty("是否需要安装")
    private Boolean installFlag;
    @ApiModelProperty("是否启用批次号")
    private Boolean lotFlag;
    @ApiModelProperty("效期管理标识")
    private Boolean guaranteeFlag;
    @ApiModelProperty("保质期时长")
    private Integer guaranteePeriod;
    @ApiModelProperty("保质期单位 [UDC]COM:TIME_UNIT")
    @SysCode(
            sys = "COM",
            mod = "TIME_UNIT"
    )
    private String guaranteePeriodUnit;
    private String guaranteePeriodUnitName;
    @ApiModelProperty("保质期天数")
    private Integer guaranteeDays;
    @ApiModelProperty("公司编码")
    private String buCode;

    @ApiModelProperty("商品生命状态")
    private boolean freeze;
}
