package com.elitesland.sale.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author Shadow
 * @since 2021-08-06 14:48
 */
@Data
public class SalContractDRespDTO implements Serializable {

    private static final long serialVersionUID = -8601986724619752546L;

    @ApiModelProperty(value = "主表ID")
    private Long masId;

    @ApiModelProperty(value = "行号")
    private BigDecimal lineNo;

    @ApiModelProperty(value = "商品ID")
    private Long itemId;

    @ApiModelProperty(value = "商品编号")
    private String itemCode;

    @ApiModelProperty(value = "商品名称")
    private String itemName;

    @ApiModelProperty(value = "商品名称2")
    private String itemName2;

    @ApiModelProperty(value = "商品规格")
    private String itemSpec;

    @ApiModelProperty(value = "品牌")
    private String itemBrand;

    @ApiModelProperty(value = "客户商品编号")
    private String custItemCode;

    @ApiModelProperty(value = "是否供应商代发")
    private Boolean suppFlag;

    @ApiModelProperty(value = "供应商ID")
    private Integer suppId;

    @ApiModelProperty(value = "数量")
    private BigDecimal qty;

    @ApiModelProperty(value = "计量单位")
    private String uom;

    @ApiModelProperty(value = "含税价格")
    private BigDecimal price;

    @ApiModelProperty(value = "不含税价格")
    private BigDecimal netPrice;

    @ApiModelProperty(value = "税码")
    private String taxCode;

    @ApiModelProperty(value = "税率编号")
    private String taxRateNo;

    @ApiModelProperty("税率描述")
    private String taxRateDesc;

    @ApiModelProperty(value = "税率")
    private BigDecimal taxRate;

    @ApiModelProperty(value = "税额")
    private BigDecimal taxAmt;

    @ApiModelProperty(value = "含税金额")
    private BigDecimal amt;

    @ApiModelProperty(value = "不含税金额")
    private BigDecimal netAmt;

    @ApiModelProperty(value = "折扣率")
    private BigDecimal discRatio;

    @ApiModelProperty(value = "折扣未税额")
    private BigDecimal discNetAmt;

    @ApiModelProperty(value = "折扣含税额")
    private BigDecimal discAmt;

    @ApiModelProperty(value = "基础价格")
    private BigDecimal basePrice;

    @ApiModelProperty(value = "单个净重")
    private BigDecimal singleNetWeight;

    @ApiModelProperty(value = "净重")
    private BigDecimal netWeight;

    @ApiModelProperty(value = "单个毛重")
    private BigDecimal singleGrossWeight;

    @ApiModelProperty(value = "毛重")
    private BigDecimal grossWeight;

    @ApiModelProperty(value = "重量单位")
    private String weightUom;

    @ApiModelProperty(value = "单个体积")
    private BigDecimal singleVolume;

    @ApiModelProperty(value = "体积")
    private BigDecimal volume;

    @ApiModelProperty(value = "体积单位")
    private String volumeUom;

    @ApiModelProperty(value = "运输方式")
    private String transType;
}
