package com.elitesland.sale.api.vo.resp.itm;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 上架商品搜索服务搜索结果
 * @author : 常浩波
 * @date 2023/03/09
 */
@Data
@ApiModel("响应spu")
public class ItmItemSpuDetailsRespVO implements Serializable {
    private static final long serialVersionUID = -8932266382781192610L;

    /**
     * spu上架ID = channelType_desId_spuId
     */
    private String spuOnShelfId;

    @ApiModelProperty("销售渠道")
    private String channelType;

    @ApiModelProperty("发货基地")
    private Long desId;
    @ApiModelProperty("发货基地编码")
    private String desCode;
    @ApiModelProperty("发货基地名称")
    private String desName;

    @ApiModelProperty("spuId")
    private Long spuId;

    @ApiModelProperty("SPU编号")
    private String spuCode;

    @ApiModelProperty("SPU名称")
    private String spuName;

    @ApiModelProperty("商品编码，和spuCode相等表示单规格，不能表示多规格")
    private String itemCode;
    @ApiModelProperty("商品名称，单规格时有值，多规格无值")
    private String itemName;

    @ApiModelProperty("整车配件 [UDC]ITM:ITEM_TYPE2")
    private String itemType2;
    private String itemType2Name;

    @ApiModelProperty("整车/配件类型")
    private String itemType3;
    private String itemType3Name;

    @ApiModelProperty("车型 [UDC]ITM:ITEM_TYPE5")
    private String itemType5;
    private String itemType5Name;

    @ApiModelProperty("系列")
    private String itemGroup;

    @ApiModelProperty("产地/原产国，udc[yst-supp:ORIGIN]")
    private String origin;
    private String originName;

    @ApiModelProperty("最低价")
    private BigDecimal minFinalPrice;
    @ApiModelProperty("最高价")
    private BigDecimal maxFinalPrice;

    @ApiModelProperty("直降前最低价")
    private BigDecimal minBeforeCutPrice;
    @ApiModelProperty("直降前最高价")
    private BigDecimal maxBeforeCutPrice;

    @ApiModelProperty("详细描述")
    private String itemDescribe;

    @ApiModelProperty("商品图片")
    private List<ItmItemAttachmentRespVO> spuImages;

    @ApiModelProperty("商品规格 SKU 信息列表")
    private List<ItmItemSkuRespVO> lmItemSkuVos;
}
