package com.elitesland.sale.api.service.shop;

import com.elitesland.sale.api.vo.resp.shop.BipItemCategoryRespVO;
import com.elitesland.sale.api.vo.resp.shop.ItemCatTreeAllRespVO;
import com.elitesland.sale.api.vo.resp.shop.ItemCatTreeRespVO;
import com.elitesland.sale.api.vo.save.shop.BipItemCategorySaveVO;
import com.elitescloud.cloudt.common.base.ApiResult;

import java.util.List;

/**
 * @auther JinXK
 * @date 2021/8/6 11:49
 */
public interface BipItemCategoryService {

    /**
     * 新增商品分类
     *
     * @param saveVO 商品分类
     * @return 商品分类ID
     */
    ApiResult<Long> save(BipItemCategorySaveVO saveVO);

    /**
     * 修改商品分类
     *
     * @param saveVO 商品分类
     * @param id     商品分类ID
     * @return 商品分类ID
     */
    ApiResult<Long> update(BipItemCategorySaveVO saveVO, Long id);

    /**
     * 修改分类的启用状态
     * <p>
     * 若是启用，则改为禁用，否则改为启用
     *
     * @param id 商品分类ID
     * @return 商品分类ID
     */
    ApiResult<Long> updateEnable(Long id);

    /**
     * 删除分类
     *
     * @param id 商品分类ID
     * @return 商品分类ID
     */
    ApiResult<Long> delete(Long id);

    /**
     * 获取商品分类
     *
     * @param id 商品分类ID
     * @return 商品分类
     */
    ApiResult<BipItemCategoryRespVO> get(Long id);

    /**
     * 获取树形数据
     * <p>
     *
     * @return 树形的商品分类
     */
    ApiResult<List<ItemCatTreeAllRespVO>> treeAll();

    /**
     * 获取树形数据
     * <p>
     *
     * @param ouId 所属公司ID
     * @return 树形的商品分类
     */
    ApiResult<List<ItemCatTreeAllRespVO>> treeAll(Long ouId);

    /**
     * 获取指定公司的树形数据
     * <p>
     * 仅仅启用的
     *
     * @param ouId 所属公司ID
     * @return 树形的商品分类
     */
    ApiResult<List<ItemCatTreeRespVO>> treeOfOu(Long ouId);

    /**
     * 获取树形数据
     * <p>
     * 仅仅启用的
     *
     * @return 树形的商品分类
     */
    ApiResult<List<ItemCatTreeRespVO>> tree();
}
