package com.elitesland.sale.api.vo.param.itm;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
@ApiModel("属性参数")
public class AttrParam implements Serializable {

    private static final long serialVersionUID = -726574919525656195L;

    @ApiModelProperty(value = "属性类型", required = true)
    private String attrType;

    @ApiModelProperty(value = "属性code", required = true)
    private String code;

    @ApiModelProperty(value = "属性name", required = true)
    private String name;

    @ApiModelProperty("属性值，支持多选，values和valueKeyword必须至少一个有值")
    private List<String> values;

    @ApiModelProperty("属性值关键字，模糊查询，values和valueKeyword必须至少一个有值")
    private String valueKeyword;
}
