package com.elitesland.sale.api.vo.resp.contract;

import com.elitescloud.cloudt.sys.component.med.BaseModelVOMedItem;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class SaleContractItemRpcVO extends BaseModelVOMedItem {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("id")
    private Long id;
    @ApiModelProperty("公司ID")
    private Long ouId;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("客户ID")
    private Long custId;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("客户名称")
    private String custName;


    @ApiModelProperty("币种")
    private String currCode;

    @ApiModelProperty("签订地点")
    private String signPlace;
    @ApiModelProperty("合同模板")
    private String saleContractTemplate;
    @ApiModelProperty("合同来源")
    private String saleContractSource;
    @ApiModelProperty("合同金额")
    private BigDecimal amt;
    @ApiModelProperty("合同金额大写")
    private String amtUpper;
    @ApiModelProperty("结算方式")
    private String settleType;
    @ApiModelProperty("结算方式其他说明")
    private String settleTypeRemark;
    @ApiModelProperty("起效日期")
    private String agreementEffectiveDateType;
    @ApiModelProperty("账期天数")
    private Integer ardays;

    @ApiModelProperty("主表ID")
    private Long masId;

    @ApiModelProperty("物料ID")
    private Long itemId;

    @ApiModelProperty("物料编码")
    private String itemCode;

    @ApiModelProperty("物料名称")
    private String itemName;

    @ApiModelProperty("物料规格")
    private String itemSpec;

    @ApiModelProperty("行号")
    private BigDecimal lineNo;
    @ApiModelProperty("要求发货日期")
    private LocalDateTime shipDate;

    @ApiModelProperty("合同编号")
    private String docNo;

    @ApiModelProperty("合同名称")
    private String docName;
    @ApiModelProperty("合同编号")
    private String contractNo;

    @ApiModelProperty("合同名称")
    private String contractName;
    @ApiModelProperty("数量")
    private BigDecimal qty;

    @ApiModelProperty("订购单位")
    private String uom;

    @ApiModelProperty("销售单价（订购单位）")
    private BigDecimal dgPrice;
    @ApiModelProperty("基本单位数量")
    private BigDecimal baseQty;

    @ApiModelProperty("基本单位")
    private String baseUom;

    @ApiModelProperty("含税单价")
    private BigDecimal taxPrice;

    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("不含税价")
    private BigDecimal netPrice;

    @ApiModelProperty("未税金额")
    private BigDecimal netAmt;

    @ApiModelProperty("税额")
    private BigDecimal taxAmt;
    @ApiModelProperty("渠道 yst-supp:SALE_CHANNEL")
    private String saleChannel;
    @ApiModelProperty("已执行数量")
    private BigDecimal executedQty;

    @ApiModelProperty("付款协议类型")
    private String protocolType;
    @ApiModelProperty("付款协议编码")
    private String protocolCode;
}
