package com.elitesland.sale.api.vo.resp.crm;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

@Data
public class AllowShipRuleCustItemVO implements Serializable {

    private static final long serialVersionUID = -3898882030399992896L;
    @ApiModelProperty(value = "销售允发期id")
    private Long id;


    @ApiModelProperty(value = "客户编码")
    private String custCode;

    @ApiModelProperty(value = "商品编码")
    private String itemCode;




    @ApiModelProperty("生效时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate validFromTime;

    @ApiModelProperty("失效时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate validToTime;

    @ApiModelProperty(value = "对应允发期规则")
    private AllowShipRuleRespVO allowShipRuleRespVO;
}
